// https://nuxt.com/docs/api/configuration/nuxt-config
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons'
import path from 'path'
import { loadEnv } from 'vite'

const mode = process.env.NODE_ENV || 'development'
const envData = loadEnv(mode, process.cwd())

export default defineNuxtConfig({
  compatibilityDate: '2025-07-15',
  devtools: { enabled: true },
  css: ['~/assets/styles/index.scss', 'element-plus/theme-chalk/dark/css-vars.css'],
  app: {
    baseURL: envData.VITE_BASE_URL || '/'
  },
  modules: [
    '@nuxt/eslint',
    '@nuxt/image',
    '@nuxt/scripts',
    '@pinia/nuxt',
    '@nuxtjs/tailwindcss',
    '@element-plus/nuxt'
  ],
  runtimeConfig: {
    public: envData
  },
  nitro: {
    compressPublicAssets: true
  },
  typescript: {
    strict: true
  },
  ssr: !!envData.VITE_SSR,
  vite: {
    plugins: [
      createSvgIconsPlugin({
        iconDirs: [
          path.resolve(process.cwd(), 'app/assets/icons')
        ],
        symbolId: 'icon-[dir]-[name]'
      })
    ]
  }
})