import { defineStore } from 'pinia'
import { getConfigInfo } from '@/api/config'

export const useAppStore = defineStore('app', () => {
  const config = ref<Record<string, any>>({})

  // 获取网站配置
  const getConfig = () => {
    return new Promise((resolve, reject) => {
      getConfigInfo()
        .then((data) => {
          config.value = data || {}
          resolve(data)
        })
        .catch((err) => {
          reject(err)
        })
    })
  }

  return {
    config,
    getConfig
  }
})
