import request from '~/utils/request'

// 登录请求
export const login = (params: Record<string, any>) => {
  return request.post('/web/user/login', { params })
}

// 发送验证码
export const sendCode = (params: Record<string, any>) => {
  return request.post('/sms/sendCode', { params })
}

// 退出登录
export const logout = () => {
  return request.post('/web/user/logout')
}

// 获取用户信息
export const getUserInfo = () => {
  return request.get('/web/user/info')
}

// 设置用户信息
export const setUserInfo = (params: Record<string, any>) => {
  return request.post('/web/user/profile', { params })
}

// 重置密码
export const resetPassword = (params: Record<string, any>) => {
  return request.post('/web/user/password/reset', { params })
}