/*
 Navicat Premium Dump SQL

 Source Server         : kjdev.qdmwd.cn
 Source Server Type    : MySQL
 Source Server Version : 50740 (5.7.40-log)
 Source Host           : 111.230.63.92:3306
 Source Schema         : kjdev_qdmwd_cn

 Target Server Type    : MySQL
 Target Server Version : 50740 (5.7.40-log)
 File Encoding         : 65001

 Date: 19/01/2026 17:55:31
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for wd_admin
-- ----------------------------
DROP TABLE IF EXISTS `wd_admin`;
CREATE TABLE `wd_admin`  (
                             `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                             `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
                             `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
                             `account` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账号',
                             `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '密码',
                             `login_time` int(10) NULL DEFAULT NULL COMMENT '最后登录时间',
                             `login_ip` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '最后登录ip',
                             `disable` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否禁用：0-否；1-是；',
                             `create_time` int(10) NOT NULL COMMENT '创建时间',
                             `update_time` int(10) NULL DEFAULT NULL COMMENT '修改时间',
                             `delete_time` int(10) NULL DEFAULT NULL COMMENT '删除时间',
                             `is_admin` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否是管理员',
                             PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '管理员表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_admin_role
-- ----------------------------
DROP TABLE IF EXISTS `wd_admin_role`;
CREATE TABLE `wd_admin_role`  (
                                  `admin_id` int(10) NOT NULL COMMENT '管理员id',
                                  `role_id` int(10) NOT NULL COMMENT '角色id',
                                  PRIMARY KEY (`admin_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色关联表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_generator_config
-- ----------------------------
DROP TABLE IF EXISTS `wd_generator_config`;
CREATE TABLE `wd_generator_config`  (
                                        `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
                                        `table_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表名',
                                        `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类名',
                                        `class_comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类注释',
                                        `module_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模块名',
                                        `fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段配置(JSON)',
                                        `config` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '其他配置(JSON)',
                                        `create_time` int(11) NOT NULL COMMENT '创建时间',
                                        `update_time` int(11) NOT NULL COMMENT '更新时间',
                                        PRIMARY KEY (`id`) USING BTREE,
                                        UNIQUE INDEX `table_name`(`table_name`) USING BTREE COMMENT '表名唯一索引'
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成器配置表' ROW_FORMAT = Dynamic;



-- ----------------------------
-- Table structure for wd_material
-- ----------------------------
DROP TABLE IF EXISTS `wd_material`;
CREATE TABLE `wd_material`  (
                                `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                                `category_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类ID',
                                `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'image' COMMENT '素材类型：image|video|file',
                                `storage` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'local' COMMENT '存储方式：local|qiniu',
                                `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '原始文件名',
                                `ext` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展名',
                                `mime` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'mime',
                                `size` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '字节',
                                `path` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '本地相对路径/七牛key',
                                `url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '访问URL',
                                `create_time` int(11) NOT NULL DEFAULT 0,
                                `update_time` int(11) NOT NULL DEFAULT 0,
                                PRIMARY KEY (`id`) USING BTREE,
                                INDEX `idx_category_id`(`category_id`) USING BTREE,
                                INDEX `idx_type`(`type`) USING BTREE,
                                INDEX `idx_storage`(`storage`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '素材' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_material_category
-- ----------------------------
DROP TABLE IF EXISTS `wd_material_category`;
CREATE TABLE `wd_material_category`  (
                                         `id` int(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                                         `pid` int(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级ID',
                                         `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
                                         `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'image' COMMENT '分类类型：image|video|file',
                                         `create_time` int(11) NOT NULL DEFAULT 0,
                                         `update_time` int(11) NOT NULL DEFAULT 0,
                                         PRIMARY KEY (`id`) USING BTREE,
                                         INDEX `idx_pid`(`pid`) USING BTREE,
                                         INDEX `idx_type`(`type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '素材分类' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_operation_log
-- ----------------------------
DROP TABLE IF EXISTS `wd_operation_log`;
CREATE TABLE `wd_operation_log`  (
                                     `id` int(11) NOT NULL AUTO_INCREMENT,
                                     `admin_id` int(11) NOT NULL COMMENT '管理员ID',
                                     `admin_name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '管理员',
                                     `account` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '管理员账号',
                                     `action` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作名称',
                                     `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '请求方式',
                                     `url` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '访问链接',
                                     `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求数据',
                                     `result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求结果',
                                     `ip` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '来源IP',
                                     `location` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作地点',
                                     `create_time` int(10) NULL DEFAULT NULL COMMENT '创建时间',
                                     PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统日志表' ROW_FORMAT = Dynamic;


-- Table structure for wd_system_menu
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_menu`;
CREATE TABLE `wd_system_menu`  (
                                   `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
                                   `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上级菜单',
                                   `type` tinyint(2) NOT NULL COMMENT '权限类型: 1=目录，2=菜单，3=按钮',
                                   `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '菜单名称',
                                   `icon_type` tinyint(1) NULL DEFAULT 0 COMMENT '菜单图标类型:1.Element图标 \n2.本地图标',
                                   `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '菜单图标',
                                   `sort` smallint(5) UNSIGNED NOT NULL DEFAULT 0 COMMENT '菜单排序',
                                   `perms` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '权限标识',
                                   `paths` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '路由地址',
                                   `component` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '前端组件',
                                   `selected` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '选中路径',
                                   `params` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '路由参数',
                                   `is_cache` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否缓存: 0=否, 1=是',
                                   `is_show` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否显示: 0=否, 1=是',
                                   `is_disable` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否禁用: 0=否, 1=是',
                                   `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
                                   `update_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统菜单表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wd_system_menu
-- ----------------------------
INSERT INTO `wd_system_menu` VALUES (1, 0, 1, '权限管理', 1, 'Lock', 60, '', 'auth', '', '', '', 0, 1, 0, 1656664556, 1768632564);
INSERT INTO `wd_system_menu` VALUES (2, 0, 2, '工作台', 2, 'icon-exit', 1000, 'workbench/index', 'workbench', 'workbench/index', '', '', 0, 1, 0, 1656664793, 1768810870);
INSERT INTO `wd_system_menu` VALUES (3, 1, 2, '菜单', 1, 'Operation', 1, 'auth.menu/lists', 'menu', 'permission/menu/index', '', '', 0, 1, 0, 1656664960, 1768632653);
INSERT INTO `wd_system_menu` VALUES (4, 1, 2, '管理员', 1, 'User', 3, 'auth.admin/lists', 'admin', 'permission/admin/index', '', '', 1, 1, 0, 1656901567, 1768791755);
INSERT INTO `wd_system_menu` VALUES (5, 1, 2, '角色', 2, 'icon-role', 2, 'auth.role/lists', 'role', 'permission/role/index', '', '', 0, 1, 0, 1656901660, 1768632657);
INSERT INTO `wd_system_menu` VALUES (6, 5, 3, '新增', 1, '', 1, 'auth.role/add', '', '', '', '', 0, 1, 0, 1657001790, 1663750625);
INSERT INTO `wd_system_menu` VALUES (7, 5, 3, '编辑', 1, '', 1, 'auth.role/edit', '', '', '', '', 0, 1, 0, 1657001924, 1663750631);
INSERT INTO `wd_system_menu` VALUES (8, 5, 3, '删除', 1, '', 1, 'auth.role/delete', '', '', '', '', 0, 1, 0, 1657001982, 1663750637);
INSERT INTO `wd_system_menu` VALUES (9, 3, 3, '新增', 1, '', 1, 'auth.menu/add', '', '', '', '', 0, 1, 0, 1657072523, 1663750565);
INSERT INTO `wd_system_menu` VALUES (10, 3, 3, '编辑', 1, '', 1, 'auth.menu/edit', '', '', '', '', 0, 1, 0, 1657073955, 1663750570);
INSERT INTO `wd_system_menu` VALUES (11, 3, 3, '删除', 1, '', 1, 'auth.menu/delete', '', '', '', '', 0, 1, 0, 1657073987, 1663750578);
INSERT INTO `wd_system_menu` VALUES (12, 4, 3, '新增', 1, '', 1, 'auth.admin/add', '', '', '', '', 0, 1, 0, 1657074035, 1663750596);
INSERT INTO `wd_system_menu` VALUES (13, 4, 3, '编辑', 1, '', 1, 'auth.admin/edit', '', '', '', '', 0, 1, 0, 1657074071, 1663750603);
INSERT INTO `wd_system_menu` VALUES (14, 4, 3, '删除', 1, '', 1, 'auth.admin/delete', '', '', '', '', 0, 1, 0, 1657074108, 1663750609);
INSERT INTO `wd_system_menu` VALUES (15, 3, 3, '详情', 1, '', 0, 'auth.menu/detail', '', '', '', '', 0, 1, 0, 1663725564, 1663750584);
INSERT INTO `wd_system_menu` VALUES (16, 4, 3, '详情', 1, '', 0, 'auth.admin/detail', '', '', '', '', 0, 1, 0, 1663725623, 1663750615);
INSERT INTO `wd_system_menu` VALUES (17, 5, 3, '详情', 1, '', 0, 'auth.role/detail', '', '', '', '', 0, 1, 0, 1766655434, 1766655434);
INSERT INTO `wd_system_menu` VALUES (18, 0, 1, '系统管理', 2, 'icon-system', 40, '', 'system', '', '', '', 1, 1, 0, 1766972930, 1768633398);
INSERT INTO `wd_system_menu` VALUES (19, 18, 2, '日志管理', 1, 'Document', 1, 'setting.system.log/lists', 'log', 'system/log/index', '', '', 0, 1, 0, 1766973014, 1768642709);
INSERT INTO `wd_system_menu` VALUES (20, 4, 3, '修改管理员状态', 1, '', 0, 'auth.admin/disable', '', '', '', '', 1, 1, 0, 1767055181, 1767055181);
INSERT INTO `wd_system_menu` VALUES (21, 18, 2, '素材管理', 1, 'Picture', 2, '', 'material', 'material/index', '', '', 0, 1, 0, 1767066295, 1768632646);
INSERT INTO `wd_system_menu` VALUES (22, 0, 1, '开发管理', 1, 'EditPen', 20, '', 'tool', '', '', '', 1, 1, 0, 1768269091, 1768632595);
INSERT INTO `wd_system_menu` VALUES (23, 22, 2, '代码生成', 2, 'icon-code', 1, 'tool.generator/lists', 'generator', 'tool/generator/index', '', '', 1, 1, 0, 1768269215, 1768793422);
INSERT INTO `wd_system_menu` VALUES (24, 23, 3, '预览代码', 0, '', 2, 'tool.generator/preview', '', '', '', '', 0, 1, 0, 1768272574, 1768272574);
INSERT INTO `wd_system_menu` VALUES (25, 23, 3, '生成代码', 0, '', 3, 'tool.generator/generate', '', '', '', '', 0, 1, 0, 1768272574, 1768272574);
INSERT INTO `wd_system_menu` VALUES (26, 23, 3, '导入数据表', 0, '', 4, 'tool.generator/import', '', '', '', '', 0, 1, 0, 1768272574, 1768295868);
INSERT INTO `wd_system_menu` VALUES (27, 23, 3, '编辑数据表', 0, '', 5, 'tool.generator/save', '', '', '', '', 0, 1, 0, 1768272574, 1768295892);
INSERT INTO `wd_system_menu` VALUES (28, 23, 3, '删除数据表', 0, '', 6, 'tool.generator/delete', '', '', '', '', 0, 1, 0, 1768272574, 1768295880);
INSERT INTO `wd_system_menu` VALUES (29, 22, 2, '编辑数据表', 2, 'icon-code', 0, 'tool.generator/save', 'generator/edit', 'tool/generator/edit', 'tool/generator', '', 1, 0, 0, 1768543150, 1768543379);
INSERT INTO `wd_system_menu` VALUES (30, 18, 2, '系统设置', 1, 'Setting', 3, 'setting.websiteSettings/detail', 'setting', 'system/setting/index', '', '', 1, 1, 0, 1768632837, 1768632837);
INSERT INTO `wd_system_menu` VALUES (31, 30, 3, '保存', 1, '', 0, 'setting.websiteSettings/edit', '', '', '', '', 1, 1, 0, 1768632984, 1768632984);
INSERT INTO `wd_system_menu` VALUES (32, 18, 1, '短信设置', 1, 'Message', 4, '', 'message', '', '', '', 0, 1, 0, 1769418853, 1769568998);
INSERT INTO `wd_system_menu` VALUES (33, 32, 2, '短信模板', 1, 'Document', 3, 'message.smsTemplate/list', 'template', 'message/template/index', '', '', 0, 1, 0, 1769418853, 1769563041);
INSERT INTO `wd_system_menu` VALUES (34, 32, 2, '短信配置', 1, 'Setting', 2, 'message.smsConfig/list', 'config', 'message/config/index', '', '', 0, 1, 0, 1769418853, 1769563055);
INSERT INTO `wd_system_menu` VALUES (35, 32, 2, '短信日志', 1, 'List', 1, 'message.smsLog/list', 'log', 'message/log/index', '', '', 0, 1, 0, 1769418853, 1769563065);
INSERT INTO `wd_system_menu` VALUES (36, 33, 3, '新增', 1, '', 4, 'message.smsTemplate/create', '', '', '', '', 0, 1, 0, 1769418853, 1769754624);
INSERT INTO `wd_system_menu` VALUES (37, 33, 3, '编辑', 1, '', 2, 'message.smsTemplate/update', '', '', '', '', 0, 1, 0, 1769418853, 1769418853);
INSERT INTO `wd_system_menu` VALUES (38, 33, 3, '删除', 1, '', 1, 'message.smsTemplate/delete', '', '', '', '', 0, 1, 0, 1769418853, 1769418853);
INSERT INTO `wd_system_menu` VALUES (39, 34, 3, '保存', 1, '', 3, 'message.smsConfig/save', '', '', '', '', 0, 1, 0, 1769418853, 1769418853);
INSERT INTO `wd_system_menu` VALUES (40, 34, 3, '切换', 1, '', 2, 'message.smsConfig/switch', '', '', '', '', 0, 1, 0, 1769418853, 1769418853);
INSERT INTO `wd_system_menu` VALUES (41, 34, 3, '测试', 1, '', 1, 'message.smsConfig/test', '', '', '', '', 0, 1, 0, 1769418853, 1769418853);
INSERT INTO `wd_system_menu` VALUES (42, 33, 3, '详情', 1, '', 3, 'message.smsTemplate/detail', '', '', '', '', 1, 1, 0, 1769754620, 1769754620);
INSERT INTO `wd_system_menu` VALUES (43, 34, 3, '删除', 1, '', 4, 'message.smsConfig/delete', '', '', '', '', 1, 1, 0, 1769754778, 1769754778);
INSERT INTO `wd_system_menu` VALUES (44, 34, 3, '详情', 1, '', 5, 'message.smsConfig/detail', '', '', '', '', 1, 1, 0, 1769754808, 1769754814);


-- ----------------------------
-- Table structure for wd_system_role
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_role`;
CREATE TABLE `wd_system_role`  (
                                   `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                                   `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
                                   `desc` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '备注',
                                   `sort` int(11) NULL DEFAULT 0 COMMENT '排序',
                                   `create_time` int(10) NULL DEFAULT NULL COMMENT '创建时间',
                                   `update_time` int(10) NULL DEFAULT NULL COMMENT '更新时间',
                                   `delete_time` int(10) NULL DEFAULT NULL COMMENT '删除时间',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_system_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_role_menu`;
CREATE TABLE `wd_system_role_menu`  (
                                        `role_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '角色ID',
                                        `menu_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '菜单ID',
                                        PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色菜单关系表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_website_settings
-- ----------------------------
CREATE TABLE `wd_website_settings`  (
                                        `id` int(11) NOT NULL AUTO_INCREMENT,
                                        `site_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '我的网站' COMMENT '网站名称',
                                        `site_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '网站LOGO图片路径',
                                        `login_bg_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录页背景图片路径',
                                        `enable_captcha` tinyint(1) NULL DEFAULT 2 COMMENT '是否开启验证码 (1: 开启, 2: 关闭)',
                                        `web_icp_record` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICP备案号',
                                        `web_police_record` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '公安备案号',
                                        `web_copyright` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '版权信息',
                                        `web_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '网站标题',
                                        `web_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '网站logo',
                                        `web_keywords` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '网站关键词',
                                        `web_description` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '网站描述',
                                        PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '网站设置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wd_website_settings
-- ----------------------------
INSERT INTO `wd_website_settings` VALUES (1, 'WdAdmin', 'static/admin/image/site_logo.png', 'static/admin/image/login_bg_image.png', 2, '京ICP备12345678号', '京公网安备11010502012345号', 'Copyright © 2026 我的网站', '我的网站标题', 'static/admin/image/web_logo.png', '关键词1,关键词2', '这是网站描述');



DROP TABLE IF EXISTS `wd_sms_code`;
CREATE TABLE `wd_sms_code`  (
                                `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary ID',
                                `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Mobile',
                                `code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Verify code',
                                `template_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template key',
                                `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Status: 0=unused 1=used 2=expired',
                                `expire_time` int(11) NOT NULL COMMENT 'Expire time',
                                `create_time` int(11) NOT NULL COMMENT 'Created time',
                                `update_time` int(11) NOT NULL COMMENT 'Updated time',
                                PRIMARY KEY (`id`) USING BTREE,
                                INDEX `idx_mobile_code`(`mobile`, `code`) USING BTREE,
                                INDEX `idx_mobile_template`(`mobile`, `template_key`) USING BTREE,
                                INDEX `idx_expire_time`(`expire_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'SMS code' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_sms_config
-- ----------------------------
DROP TABLE IF EXISTS `wd_sms_config`;
CREATE TABLE `wd_sms_config`  (
                                  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary ID',
                                  `gateway` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'EasySms gateway name',
                                  `gateway_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Gateway display name',
                                  `config_data` json NOT NULL COMMENT 'Gateway config json (encrypted)',
                                  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Status: 0=disabled 1=enabled',
                                  `create_time` int(11) NOT NULL COMMENT 'Created time',
                                  `update_time` int(11) NOT NULL COMMENT 'Updated time',
                                  PRIMARY KEY (`id`) USING BTREE,
                                  UNIQUE INDEX `uk_gateway`(`gateway`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'SMS config' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_sms_log
-- ----------------------------
DROP TABLE IF EXISTS `wd_sms_log`;
CREATE TABLE `wd_sms_log`  (
                               `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary ID',
                               `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Mobile',
                               `template_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template key',
                               `template_value` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template value (provider template ID)',
                               `params` json NULL COMMENT 'Send params',
                               `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'Content',
                               `gateway` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'EasySms gateway name',
                               `request_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Request ID',
                               `biz_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Biz ID',
                               `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Status: 0=processing 1=success 2=failed',
                               `error_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Error code',
                               `error_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'Error message',
                               `send_time` int(11) NOT NULL COMMENT 'Send time',
                               `create_time` int(11) NOT NULL COMMENT 'Created time',
                               PRIMARY KEY (`id`) USING BTREE,
                               INDEX `idx_mobile_template`(`mobile`, `template_key`) USING BTREE,
                               INDEX `idx_send_time`(`send_time`) USING BTREE,
                               INDEX `idx_gateway_status`(`gateway`, `status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'SMS log' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `wd_sms_template`;
CREATE TABLE `wd_sms_template`  (
                                    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary ID',
                                    `template_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template name',
                                    `template_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template key',
                                    `template_value` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Template value (provider template ID)',
                                    `create_time` int(11) NOT NULL COMMENT 'Created time',
                                    `update_time` int(11) NOT NULL COMMENT 'Updated time',
                                    PRIMARY KEY (`id`) USING BTREE,
                                    UNIQUE INDEX `uk_template_key`(`template_key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'SMS template' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wd_sms_template
-- ----------------------------
INSERT INTO `wd_sms_template` VALUES (1, '手机号登录', 'mobile_login', 'SMS_464806134', 1769409296, 1769482063);
INSERT INTO `wd_sms_template` VALUES (2, '修改密码', 'reset_password', 'SMS_175320305', 1769492960, 1769492960);

SET FOREIGN_KEY_CHECKS = 1;


DROP TABLE IF EXISTS `wd_user`;
CREATE TABLE `wd_user`  (
                            `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
                            `user_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户编号',
                            `account` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户账号',
                            `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机号',
                            `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
                            `nickname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
                            `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '头像',
                            `login_time` int(11) NULL DEFAULT NULL COMMENT '最后登录时间',
                            `login_ip` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '最后登录ip',
                            `disable` tinyint(1) UNSIGNED NULL DEFAULT 2 COMMENT '是否禁用：2-否；1-是；',
                            `create_time` int(10) NOT NULL DEFAULT 0 COMMENT '注册时间',
                            `update_time` int(10) NOT NULL DEFAULT 0 COMMENT '更新时间',
                            PRIMARY KEY (`id`) USING BTREE,
                            UNIQUE INDEX `uk_mobile`(`mobile`) USING BTREE COMMENT '手机号唯一',
                            UNIQUE INDEX `idx_user_no`(`user_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户信息表' ROW_FORMAT = DYNAMIC;
