/*
 Navicat Premium Dump SQL

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50726 (5.7.26)
 Source Host           : localhost:3306
 Source Schema         : wd_uni_php_dev

 Target Server Type    : MySQL
 Target Server Version : 50726 (5.7.26)
 File Encoding         : 65001

 Date: 16/12/2025 15:28:05
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for wd_admin
-- ----------------------------
DROP TABLE IF EXISTS `wd_admin`;
CREATE TABLE `wd_admin`  (
 `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
 `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
 `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
 `account` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账号',
 `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '密码',
 `login_time` int(10) NULL DEFAULT NULL COMMENT '最后登录时间',
 `login_ip` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '最后登录ip',
 `disable` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否禁用：0-否；1-是；',
 `create_time` int(10) NOT NULL COMMENT '创建时间',
 `update_time` int(10) NULL DEFAULT NULL COMMENT '修改时间',
 `delete_time` int(10) NULL DEFAULT NULL COMMENT '删除时间',
 `is_admin` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否是管理员',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '管理员表' ROW_FORMAT = DYNAMIC;

INSERT INTO `wd_admin` (`id`, `name`, `avatar`, `account`, `password`, `login_time`, `login_ip`, `disable`, `create_time`, `update_time`, `delete_time`, `is_admin`) VALUES (1, 'admin', 'static/admin/image/default_avatar.png', 'admin', '$2y$10$mZbOfKy41mmeR4FnmVPkI.IlvtrJc6cDpVFh8Jq4g38xrCW7nBM5O', 1766628503, '127.0.0.1', 0, 1764568349, 1766628503, NULL, 1);




-- ----------------------------
-- Table structure for wd_admin_role
-- ----------------------------
DROP TABLE IF EXISTS `wd_admin_role`;
CREATE TABLE `wd_admin_role`  (
`admin_id` int(10) NOT NULL COMMENT '管理员id',
`role_id` int(10) NOT NULL COMMENT '角色id',
PRIMARY KEY (`admin_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色关联表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_system_menu
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_menu`;
CREATE TABLE `wd_system_menu`  (
 `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
 `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上级菜单',
 `type` tinyint(2) NOT NULL COMMENT '权限类型: 1=目录，2=菜单，3=按钮',
 `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '菜单名称',
 `icon_type` tinyint(1) NULL DEFAULT 0 COMMENT '菜单图标类型:1.Element图标 \n2.本地图标',
 `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '菜单图标',
 `sort` smallint(5) UNSIGNED NOT NULL DEFAULT 0 COMMENT '菜单排序',
 `perms` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '权限标识',
 `paths` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '路由地址',
 `component` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '前端组件',
 `selected` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '选中路径',
 `params` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '路由参数',
 `is_cache` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否缓存: 0=否, 1=是',
 `is_show` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否显示: 0=否, 1=是',
 `is_disable` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否禁用: 0=否, 1=是',
 `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
 `update_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 191 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统菜单表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wd_system_menu
-- ----------------------------
INSERT INTO `wd_system_menu` VALUES (4, 0, 1, '权限管理', 1, 'Lock', 300, '', 'system', '', '', '', 0, 1, 0, 1656664556, 1766046612);
INSERT INTO `wd_system_menu` VALUES (5, 0, 2, '工作台', 1, 'Monitor', 1000, 'workbench/index', 'workbench', 'workbench/index', '', '', 0, 1, 0, 1656664793, 1766383178);
INSERT INTO `wd_system_menu` VALUES (6, 4, 2, '菜单', 1, 'Operation', 100, 'auth.menu/lists', 'menu', 'permission/menu/index', '', '', 1, 1, 0, 1656664960, 1766046625);
INSERT INTO `wd_system_menu` VALUES (7, 4, 2, '管理员', 1, '', 80, 'auth.admin/lists', 'admin', 'permission/admin/index', '', '', 0, 1, 0, 1656901567, 1766106305);
INSERT INTO `wd_system_menu` VALUES (8, 4, 2, '角色', 1, 'Female', 90, 'auth.role/lists', 'role', 'permission/role/index', '', '', 0, 1, 0, 1656901660, 1766046637);
INSERT INTO `wd_system_menu` VALUES (12, 8, 3, '新增', 1, '', 1, 'auth.role/add', '', '', '', '', 0, 1, 0, 1657001790, 1663750625);
INSERT INTO `wd_system_menu` VALUES (14, 8, 3, '编辑', 1, '', 1, 'auth.role/edit', '', '', '', '', 0, 1, 0, 1657001924, 1663750631);
INSERT INTO `wd_system_menu` VALUES (15, 8, 3, '删除', 1, '', 1, 'auth.role/delete', '', '', '', '', 0, 1, 0, 1657001982, 1663750637);
INSERT INTO `wd_system_menu` VALUES (16, 6, 3, '新增', 1, '', 1, 'auth.menu/add', '', '', '', '', 0, 1, 0, 1657072523, 1663750565);
INSERT INTO `wd_system_menu` VALUES (17, 6, 3, '编辑', 1, '', 1, 'auth.menu/edit', '', '', '', '', 0, 1, 0, 1657073955, 1663750570);
INSERT INTO `wd_system_menu` VALUES (18, 6, 3, '删除', 1, '', 1, 'auth.menu/delete', '', '', '', '', 0, 1, 0, 1657073987, 1663750578);
INSERT INTO `wd_system_menu` VALUES (19, 7, 3, '新增', 1, '', 1, 'auth.admin/add', '', '', '', '', 0, 1, 0, 1657074035, 1663750596);
INSERT INTO `wd_system_menu` VALUES (20, 7, 3, '编辑', 1, '', 1, 'auth.admin/edit', '', '', '', '', 0, 1, 0, 1657074071, 1663750603);
INSERT INTO `wd_system_menu` VALUES (21, 7, 3, '删除', 1, '', 1, 'auth.admin/delete', '', '', '', '', 0, 1, 0, 1657074108, 1663750609);
INSERT INTO `wd_system_menu` VALUES (68, 6, 3, '详情', 1, '', 0, 'auth.menu/detail', '', '', '', '', 0, 1, 0, 1663725564, 1663750584);
INSERT INTO `wd_system_menu` VALUES (69, 7, 3, '详情', 1, '', 0, 'auth.admin/detail', '', '', '', '', 0, 1, 0, 1663725623, 1663750615);
INSERT INTO `wd_system_menu` VALUES (189, 7, 3, '获取管理员信息', 1, 'el-icon-test', 100, 'auth.admin/mySelf', 'admin', 'admin/mySelf', '', '', 0, 0, 0, 1765856947, 1765856947);
INSERT INTO `wd_system_menu` VALUES (190, 0, 2, '仪表盘', 1, 'DataBoard', 0, '', 'dashboard', 'dashboard/index', '', '', 0, 1, 0, 1766024757, 1766482435);


-- ----------------------------
-- Table structure for wd_system_role
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_role`;
CREATE TABLE `wd_system_role`  (
 `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
 `name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
 `desc` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '备注',
 `sort` int(11) NULL DEFAULT 0 COMMENT '排序',
 `create_time` int(10) NULL DEFAULT NULL COMMENT '创建时间',
 `update_time` int(10) NULL DEFAULT NULL COMMENT '更新时间',
 `delete_time` int(10) NULL DEFAULT NULL COMMENT '删除时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表' ROW_FORMAT = DYNAMIC;



-- ----------------------------
-- Table structure for wd_system_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `wd_system_role_menu`;
CREATE TABLE `wd_system_role_menu`  (
    `role_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '角色ID',
    `menu_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '菜单ID',
    PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色菜单关系表' ROW_FORMAT = DYNAMIC;

CREATE TABLE `wd_operation_log`  (
 `id` int(11) NOT NULL AUTO_INCREMENT,
 `admin_id` int(11) NOT NULL COMMENT '管理员ID',
 `admin_name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '管理员',
 `account` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '管理员账号',
 `action` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作名称',
 `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '请求方式',
 `url` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '访问链接',
 `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求数据',
 `result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求结果',
 `ip` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '来源IP',
 `create_time` int(10) NULL DEFAULT NULL COMMENT '创建时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统日志表' ROW_FORMAT = Dynamic;


