<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者,助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件,不加密,并不代表开源,未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace core\base;

use think\exception\ValidateException;
use think\Validate;

/**
 * 基础验证类
 * 支持链式调用的验证器
 */
class BaseValidate extends Validate
{
    public string $method = 'GET';

    /**
     * 验证是否为 POST 请求
     * @return $this
     * @throws ValidateException
     */
    public function post()
    {
        if (!request()->isPost()) {
            throw new ValidateException('请求方式错误,请使用POST请求');
        }
        $this->method = 'POST';
        return $this;
    }

    /**
     * 验证是否为 GET 请求
     * @return $this
     * @throws ValidateException
     */
    public function get()
    {
        if (!request()->isGet()) {
            throw new ValidateException('请求方式错误,请使用GET请求');
        }
        return $this;
    }

    /**
     * 执行验证并返回验证后的数据
     * @param string $scene 验证场景
     * @return array 验证后的数据
     * @throws ValidateException
     */
    public function goCheck($scene = '')
    {
        // 获取请求参数
        if ($this->method == 'GET') {
            $params = request()->get();
        } else {
            $params = request()->post();
        }

        // 设置验证场景
        if (!empty($scene)) {
            $this->scene($scene);
        }

        // 执行验证
        if (!$this->check($params)) {
            throw new ValidateException($this->getError());
        }

        return $params;
    }
}
