<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace core\base;


use app\adminapi\validate\Page;

abstract class BaseService
{
    protected $request;
    protected $model;

    protected static $error;

    public function __construct()
    {
        $this->request = request();
    }

    public function pageQuery($model, $each = null)
    {
        $page_params = $this->getPageParam();
        $page = $page_params['page'];
        $limit = $page_params['limit'];
        $list = $model->paginate([
            'list_rows' => $limit,
            'page' => $page,
        ]);
        if (!empty($each)) {
            $list = $list->each($each);
        }
        return $list->toArray();
    }

    public function getPageParam()
    {
        // 获取分页参数并设置默认值
        $page = [
            'page' => $this->request->param('page', 1),
            'limit' => $this->request->param('limit', 15)
        ];

        // 验证参数
        validate(Page::class)->check($page);

        return $page;
    }

    public static function getError() : string
    {
        if (false === self::hasError()) {
            return '系统错误';
        }
        return self::$error;
    }

    public static function setError($error) : void
    {
        !empty($error) && self::$error = $error;
    }

    public static function hasError() : bool
    {
        return !empty(self::$error);
    }

}