<?php

namespace core\base;

use think\Model;

/**
 * 基础模型
 */
class BaseApiModel extends Model
{
    // 模型初始化
    protected function initialize()
    {
        parent::initialize();
    }

    public function setImagesAttr($value)
    {
        return is_array($value) ? json_encode($value, JSON_UNESCAPED_UNICODE) : $value;
    }

    public function getImagesAttr($value)
    {
        if (is_array($value)) return array_values(array_filter($value, fn($v) => $v !== '' && $v !== null));
        if (empty($value)) return [];
        $arr = json_decode($value, true) ?: [];
        return array_values(array_filter($arr, fn($v) => $v !== '' && $v !== null));
    }

    public function setFilesAttr($value)
    {
        return is_array($value) ? json_encode($value, JSON_UNESCAPED_UNICODE) : $value;
    }

    public function getFilesAttr($value)
    {
        if (is_array($value)) return array_values(array_filter($value, fn($v) => $v !== '' && $v !== null));
        if (empty($value)) return [];
        $arr = json_decode($value, true) ?: [];
        return array_values(array_filter($arr, fn($v) => $v !== '' && $v !== null));
    }
}
