<?php
namespace app\common\service\storage;

class StorageFactory
{
    public static function create(?string $driver = null): StorageInterface
    {
        $driver = strtolower($driver ?: (string)config('storage.default', 'local'));

        switch ($driver) {
            case 'local':
                return new LocalStorage();
            case 'qiniu':
                return new QiniuStorage();
            default:
                throw new \RuntimeException('Unsupported storage driver: ' . $driver);
        }
    }
}
