<?php
declare (strict_types=1);

namespace app\common\service\sms;

class SmsConfigMapping
{
    public const GATEWAY_REQUIRED_FIELDS = [
        'aliyun' => ['access_key_id', 'access_key_secret', 'sign_name'],
        'qcloud' => ['sdk_app_id', 'secret_id', 'secret_key', 'sign_name'],
        'huawei' => ['endpoint', 'app_key', 'app_secret', 'from'],
        'qiniu' => ['access_key', 'secret_key'],
        'yunpian' => ['api_key'],
        'submail' => ['app_id', 'app_key'],
        'juhe' => ['app_key'],
        'sendcloud' => ['sms_user', 'sms_key'],
        'baidu' => ['ak', 'sk', 'invoke_id', 'domain'],
    ];

    public const GATEWAY_OPTIONAL_FIELDS = [
        'aliyun' => [],
        'qcloud' => [],
        'huawei' => ['callback'],
        'qiniu' => [],
        'yunpian' => ['signature'],
        'submail' => [],
        'juhe' => [],
        'sendcloud' => [],
        'baidu' => [],
    ];

    public const GATEWAY_NAMES = [
        'aliyun' => '阿里云短信',
        'qcloud' => '腾讯云短信',
        'huawei' => '华为云短信',
        'qiniu' => '七牛云短信',
        'yunpian' => '云片短信',
        'submail' => 'Submail短信',
        'juhe' => '聚合数据短信',
        'sendcloud' => 'SendCloud短信',
        'baidu' => '百度云短信',
    ];
}
