<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\common\service;


class FileService
{
    public static function getFileUrl(string $uri = '', string $type = '') : string
    {
        if (strstr($uri, 'http://'))  return $uri;
        if (strstr($uri, 'https://')) return $uri;

        $domain = request()->domain();

        return self::format($domain, $uri);
    }

    public static function format($domain, $uri)
    {
        // 处理域名
        $domainLen = strlen($domain);
        $domainRight = substr($domain, $domainLen -1, 1);
        if ('/' == $domainRight) {
            $domain = substr_replace($domain,'',$domainLen -1, 1);
        }

        // 处理uri
        $uriLeft = substr($uri, 0, 1);
        if('/' == $uriLeft) {
            $uri = substr_replace($uri,'',0, 1);
        }

        return trim($domain) . '/' . trim($uri);
    }

    /**
     * 移除全路径
     * @param string $uri
     * @return string
     */
    public static function setFileUrl(string $uri = ''): string
    {
        $uri = trim($uri);
        if ($uri === '') {
            return '';
        }

        $storageConfig = (array)config('storage', []);
        $driver = strtolower((string)($storageConfig['default'] ?? 'local'));
        $localDomain = rtrim((string)request()->domain(), '/');

        $domains = [];
        foreach ($storageConfig as $key => $value) {
            if (!is_array($value)) {
                continue;
            }
            $domain = trim((string)($value['domain'] ?? ''));
            if ($domain !== '') {
                $domains[] = rtrim($domain, '/');
            }
        }

        if (str_starts_with($uri, 'http://') || str_starts_with($uri, 'https://')) {
            if ($localDomain !== '' && str_starts_with($uri, $localDomain . '/')) {
                return substr($uri, strlen($localDomain) + 1);
            }
            foreach ($domains as $domain) {
                if ($uri === $domain || str_starts_with($uri, $domain . '/')) {
                    return $uri;
                }
            }
            return $uri;
        }

        if ($driver === 'local') {
            return $uri;
        }

        $domain = '';
        if (isset($storageConfig[$driver]) && is_array($storageConfig[$driver])) {
            $domain = (string)($storageConfig[$driver]['domain'] ?? '');
        }
        if ($domain === '') {
            return $uri;
        }

        return rtrim($domain, '/') . '/' . ltrim($uri, '/');
    }
}
