<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\common\cache;

use app\adminapi\service\auth\AuthService;
use think\facade\Cache;

class AdminAuthCache
{
    private $prefix = 'admin_auth_';
    private $cacheAllKey = '';      //全部权限的key
    private $cacheAdminKey = '';

    public function __construct()
    {
        $this->cacheAllKey = $this->prefix . 'all';
        $this->cacheAdminKey = $this->prefix . 'admin_';
    }

    /**
     * @Desc 获取全部权限缓存
     * @Create on 2025/12/11 下午3:09
     * @Create by woailuo
     */
    public function getAllUrl()
    {
        $cacheAuth = Cache::get($this->cacheAllKey);
        if ($cacheAuth) {
            return $cacheAuth;
        }
        $getAllUrl = AuthService::getAllAuth();
        Cache::set($this->cacheAllKey, $getAllUrl);
        return $getAllUrl;
    }

    /**
     * @Desc 获取管理员权限缓存
     * @Create on 2025/12/15 下午4:22
     * @Create by woailuo
     */
    public function getAdminUrl($adminId){
        $cacheAdminURL = Cache::get($this->cacheAdminKey.$adminId);

        if ($cacheAdminURL) {
            return $cacheAdminURL;
        }
        $getAdminUrl = AuthService::getAdminAuth($adminId);
        Cache::set($this->cacheAdminKey.$adminId, $getAdminUrl);
        return $getAdminUrl;
    }

    /**
     * @Desc 删除管理员权限缓存
     * @param $adminId
     * @return bool
     */
    public function deleteAdminAuth($adminId)
    {
        return Cache::delete($this->cacheAdminKey . $adminId);
    }

}