<?php
declare (strict_types=1);

namespace app\api\validate\web;

use core\base\BaseValidate;

/**
 * 用户验证器
 */
class UserValidate extends BaseValidate
{
    protected $rule = [
        'mobile' => 'require|regex:/^1[3-9]\d{9}$/',
        'type' => 'require|in:1,2',
        'scene' => 'require',
        'password' => 'min:8|regex:/^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d]{8,}$/',
        'avatar' => 'require|max:255',
    ];

    protected $message = [
        'avatar.require' => '请上传头像',
        'avatar.max' => '头像地址长度不能超过255个字符',
        'mobile.require' => '请输入手机号',
        'mobile.regex' => '手机号格式错误',
        'type.require' => '请选择登录方式',
        'type.in' => '登录方式错误',
        'code.require' => '请输入验证码',
        'code.requireIf' => '请输入验证码',
        'password.require' => '请输入密码',
        'password.requireIf' => '请输入密码',
        'password.min' => '密码长度不能少于8位',
        'password.regex' => '密码必须包含字母和数字',
        'scene.require' => '请选择场景值',
        'scene.requireIf' => '请选择场景值',
    ];

    public function sceneLogin()
    {
        return $this->only(['mobile', 'type', 'code', 'scene', 'password'])
            ->remove('scene', 'require')
            ->remove('password', 'require')
            ->append('code', 'requireIf:type,1')
            ->append('scene', 'requireIf:type,1')
            ->append('password', 'requireIf:type,2');
    }

    public function sceneReset()
    {
        return $this->only(['mobile', 'code', 'scene', 'password']);
    }

    public function sceneProfile()
    {
        return $this->only(['avatar']);
    }
}
