<?php
use think\facade\Route;

// Swagger API 文档路由（公开）
Route::group('swagger', function () {
    Route::rule('ui', 'app\api\controller\SwaggerController@ui', 'GET|OPTIONS');
    Route::rule('json', 'app\api\controller\SwaggerController@json', 'GET|OPTIONS');
})->middleware([\app\api\middleware\CorsMiddleware::class]);

// 短信相关路由（公开）
Route::group('sms', function () {
    Route::rule('sendCode', 'app\api\controller\SmsController@sendCode', 'POST|OPTIONS');
})->middleware([\app\api\middleware\CorsMiddleware::class]);

// Upload route (public)
Route::rule('upload', 'app\api\controller\UploadController@upload', 'POST|OPTIONS')
    ->middleware([\app\api\middleware\CorsMiddleware::class]);

// 公开路由（不需要登录）
Route::group('web/user', function () {
    Route::rule('login', 'app\api\controller\web\UserController@login', 'POST|OPTIONS');
})->middleware([\app\api\middleware\CorsMiddleware::class]);

Route::group('web/config', function () {
    Route::rule('getConfig', 'app\api\controller\web\ConfigController@getConfig', 'GET|OPTIONS');
})->middleware([\app\api\middleware\CorsMiddleware::class]);

// 需要登录的路由
Route::group('web/user', function () {
    Route::rule('password/reset', 'app\api\controller\web\UserController@resetPassword', 'POST|OPTIONS');
    Route::rule('info', 'app\api\controller\web\UserController@info', 'GET|OPTIONS');
    Route::rule('profile', 'app\api\controller\web\UserController@profile', 'POST|OPTIONS');
    Route::rule('logout', 'app\api\controller\web\UserController@logout', 'POST|OPTIONS');
})->middleware([
    \app\api\middleware\CorsMiddleware::class,
    \app\api\middleware\TokenMiddleware::class,
]);
