<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\api\controller\web;

use app\api\service\web\WebsiteSettingsService;
use core\base\BaseApiController;

class ConfigController extends BaseApiController
{
    /**
     * @Desc 获取配置
     * @Create on 2026/1/23
     *
     * @OA\Get(
     *     path="/web/config/getConfig",
     *     summary="获取配置",
     *     tags={"WEB"},
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="获取成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *             @OA\Property(property="web_icp_record", type="string", description="ICP备案号", maxLength=100, example="京ICP备12345678号"),
     *             @OA\Property(property="web_police_record", type="string", description="公安备案号", maxLength=100, example="京公网安备11010502012345号"),
     *             @OA\Property(property="web_copyright", type="string", description="版权信息", maxLength=255, example="Copyright © 2026 我的网站"),
     *             @OA\Property(property="web_title", type="string", description="网站标题（必填）", maxLength=255, example="我的网站标题"),
     *             @OA\Property(property="web_logo", type="string", description="网站logo路径（必填）", maxLength=255, example="/uploads/web_logo.png"),
     *             @OA\Property(property="web_keywords", type="string", description="网站关键词", maxLength=500, example="关键词1,关键词2"),
     *             @OA\Property(property="web_description", type="string", description="网站描述", maxLength=1000, example="这是网站描述"),
     *             )
     *         )
     *     )
     * )
     */
    public function getConfig()
    {
        $result = (new WebsiteSettingsService())->getWebsiteSettingsInfo();
        return success('请求成功',$result);
    }

}