<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------

namespace app\adminapi\validate\setting;

use core\base\BaseValidate;

/**
 * 网站设置验证器
 * Class WebsiteSettingsValidate
 * @package app\adminapi\validate\setting
 */
class WebsiteSettingsValidate extends BaseValidate
{
    protected $rule = [
        'site_name' => 'require|max:255',
        'site_logo' => 'max:255',
        'login_bg_image' => 'max:255',
        'enable_captcha' => 'require|in:1,2',
        'web_icp_record' => 'max:100',
        'web_police_record' => 'max:100',
        'web_copyright' => 'max:255',
        'web_title' => 'require|max:255',
        'web_logo' => 'require|max:255',
        'web_keywords' => 'max:500',
        'web_description' => 'max:1000'
    ];

    protected $message = [
        'site_name.require' => '网站名称不能为空',
        'site_name.max' => '网站名称不能超过255个字符',
        'site_logo.max' => '网站LOGO路径不能超过255个字符',
        'login_bg_image.max' => '登录背景图片路径不能超过255个字符',
        'enable_captcha.require' => '验证码开关不能为空',
        'enable_captcha.in' => '验证码开关值无效，只能是1或2',
        'web_icp_record.max' => 'ICP备案号不能超过100个字符',
        'web_police_record.max' => '公安备案号不能超过100个字符',
        'web_copyright.max' => '版权信息不能超过255个字符',
        'web_title.require' => 'WEB网站标题不能为空',
        'web_title.max' => 'WEB网站标题不能超过255个字符',
        'web_logo.require' => 'WEB网站logo不能为空',
        'web_logo.max' => 'WEB网站logo路径不能超过255个字符',
        'web_keywords.max' => '网站关键词不能超过500个字符',
        'web_description.max' => '网站描述不能超过1000个字符'
    ];

    protected $scene = [
        'edit' => ['site_name', 'site_logo', 'login_bg_image', 'enable_captcha', 'web_icp_record', 'web_police_record', 'web_copyright', 'web_title', 'web_logo', 'web_keywords', 'web_description']
    ];
}