<?php
declare (strict_types=1);

namespace app\adminapi\validate\message;

use core\base\BaseValidate;

class SmsTemplateValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|integer',
        'template_name' => 'require|max:50',
        'template_key' => 'require|max:50|alphaDash',
        'template_value' => 'require|max:50',
    ];

    protected $message = [
        'id.require' => 'ID不能为空',
        'id.integer' => 'ID必须是整数',
        'template_name.require' => '模板名称不能为空',
        'template_name.max' => '模板名称最大长度为50',
        'template_key.require' => '模板键名不能为空',
        'template_key.max' => '模板键名最大长度为50',
        'template_key.alphaDash' => '模板键名只能是字母、数字、下划线和破折号',
        'template_value.require' => '模板值不能为空',
        'template_value.max' => '模板值最大长度为50',
    ];

    public function sceneCreate()
    {
        return $this->only(['template_name', 'template_key', 'template_value']);
    }

    public function sceneUpdate()
    {
        return $this->only(['id', 'template_name', 'template_key', 'template_value']);
    }
}
