<?php
declare (strict_types=1);

namespace app\adminapi\validate\message;

use core\base\BaseValidate;

class SmsConfigValidate extends BaseValidate
{
    protected $rule = [
        'gateway' => 'require|max:20',
        'config_data' => 'require|array',
        'test_mobile' => 'require|regex:/^1[3-9]\d{9}$/',
    ];

    protected $message = [
        'gateway.require' => '网关不能为空',
        'gateway.max' => '网关最大长度为20',
        'config_data.require' => '配置数据不能为空',
        'config_data.array' => '配置数据必须是数组',
        'test_mobile.require' => '手机号不能为空',
        'test_mobile.regex' => '手机号格式不正确',
    ];

    public function sceneSave()
    {
        return $this->only(['gateway', 'config_data']);
    }

    public function sceneTest()
    {
        return $this->only(['gateway', 'test_mobile']);
    }
}
