<?php
namespace app\adminapi\validate\material;

use core\base\BaseValidate;

class MaterialValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|integer|min:1',
        'category_id' => 'integer|egt:0',
        'type' => 'in:image,video,file',
        'keyword' => 'max:100',
    ];

    protected $message = [
        'id.require' => '缺少id',
        'id.integer' => 'id必须是整数',
        'type.in' => 'type 仅支持 image/video/file',
    ];

    public function sceneAdd() { return $this->only(['category_id','type']); }
    public function sceneLists() { return $this->only(['category_id','type','keyword']); }
    public function sceneDetail() { return $this->only(['id']); }
    public function sceneDelete() { 
        return $this->only(['id'])
            ->remove('id', 'integer|min:1'); 
    }
    public function sceneMove() {
        return $this->only(['id','category_id'])
            ->remove('id', 'integer|min:1');
    }
}
