<?php
namespace app\adminapi\validate\material;

use core\base\BaseValidate;

class MaterialCategoryValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|integer|min:1',
        'pid' => 'integer|egt:0',
        'name' => 'require|max:50',
        'type' => 'in:image,video,file',
    ];

    protected $message = [
        'name.require' => '请填写分类名称',
        'type.in' => 'type 仅支持 image/video/file',
    ];

    public function sceneTree() { return $this->only(['type']); }
    public function sceneAdd() { return $this->only(['pid','name','type'])->append('type', 'require'); }
    public function sceneEdit() { return $this->only(['id','pid','name','type'])->remove('name','require'); }
    public function sceneDelete() { return $this->only(['id']); }
}
