<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\validate\login;

use core\base\BaseValidate;

class LoginValidate extends BaseValidate
{
    protected $rule = [
        'account' => 'require',
        'password' => 'require',
        'captcha' => 'max:10',
        'captcha_key' => 'max:64',
    ];

    protected $message = [
        'account.require' => '请输入账号',
        'password.require' => '请输入密码',
        'captcha.max' => '验证码格式错误',
        'captcha_key.max' => '验证码标识格式错误',
    ];

    public function sceneLogin()
    {
        return $this->only(['account', 'password', 'captcha', 'captcha_key']);
    }
}