<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\validate\auth;

use app\adminapi\model\auth\SystemRole;
use core\base\BaseValidate;

class RoleValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|checkRole',
        'name' => 'require|max:64|unique:' . SystemRole::class . ',name',
        'menu_id' => 'require|array',
    ];

    protected $message = [
        'id.require' => '请选择角色',
        'name.require' => '请输入角色名称',
        'name.max' => '角色名称最长为16个字符',
        'name.unique' => '角色名称已存在',
        'menu_id.unique' => '请选择菜单',
        'menu_id.array' => '菜单格式错误'
    ];

    public function sceneAdd()
    {
        return $this->only(['name']);
    }

    public function sceneEdit()
    {
        return $this->only(['id', 'name'])
            ->remove('name', 'unique'); // 编辑时移除唯一性验证，在控制器中单独处理
    }

    public function sceneDelete()
    {
        return $this->only(['id']);
    }

    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    public function sceneLists()
    {
        return $this->only(['name', 'page', 'limit'])
            ->remove('name', 'require|unique'); // 列表查询时name为可选，移除必填和唯一性验证
    }

    protected function checkRole($value, $rule, $data=[])
    {
        // 1. 如果是数组，进行批量验证
        if (is_array($value)) {
            if (empty($value)) return '请选择角色';
            $ids = array_unique($value);
            $count = (new SystemRole)->whereIn('id', $ids)->count();
            if ($count != count($ids)) {
                return '所选角色不存在';
            }
            return true;
        }

        // 2. 如果是单个值（无论是 int 还是 string），都由这里统一处理
        if (!(new SystemRole)->find($value)) {
            return '角色不存在';
        }
        return true;
    }

    /**
     * @Desc 分配权限
     * @Create on 2025/12/9 上午10:19
     * @Create by woailuo
     */
    public function sceneAssignPermission(){
        return $this->only(['id','menu_id'])
            ->append('menu_id', 'array');
    }
}