<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\validate\auth;

use app\adminapi\model\auth\SystemMenu;
use core\base\BaseValidate;

class MenuValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require',
        'pid' => 'require|checkPid',
        'type' => 'require|in:1,2,3',
        'name' => 'require|length:1,30|checkUniqueName',
        'icon' => 'max:100',
        'icon_type' => 'in:0,1,2',
        'sort' => 'require|egt:0',
        'perms' => 'max:100',
        'paths' => 'max:200',
        'component' => 'max:200',
        'selected' => 'max:200',
        'params' => 'max:200',
        'is_show' => 'require|in:0,1',
        'is_disable' => 'require|in:0,1',
    ];

    protected $message = [
        'id.require' => '参数缺失',
        'pid.require' => '请选择上级菜单',
        'type.require' => '请选择菜单类型',
        'type.in' => '菜单类型参数值错误',
        'name.require' => '请填写菜单名称',
        'name.length' => '菜单名称长度需为1~30个字符',
        'icon.max' => '图标名称不能超过100个字符',
        'icon_type.require' => '请选择图标类型',
        'icon_type.in' => '图标类型参数值错误',
        'sort.require' => '请填写排序',
        'sort.egt' => '排序值需大于或等于0',
        'perms.max' => '权限字符不能超过100个字符',
        'paths.max' => '路由地址不能超过200个字符',
        'component.max' => '组件路径不能超过200个字符',
        'selected.max' => '选中菜单路径不能超过200个字符',
        'params.max' => '路由参数不能超过200个字符',
        'is_show.require' => '请选择显示状态',
        'is_show.in' => '显示状态参数值错误',
        'is_disable.require' => '请选择菜单状态',
        'is_disable.in' => '菜单状态参数值错误',
    ];

    public function sceneAdd()
    {
        return $this->remove('id', true);
    }

    public function sceneEdit()
    {
        return $this->remove('id', true);
    }

    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    public function sceneDelete()
    {
        return $this->only(['id']);
    }


    public function sceneLists()
    {
        // 列表查询不需要任何参数校验
        return $this;
    }

    /**
     * @notes 校验上级
     */
    protected function checkPid($value, $rule, $data)
    {
        if (!empty($data['id']) && $data['id'] == $value) {
            return '上级菜单不能选择自己';
        }
        return true;
    }

    protected function checkUniqueName($value, $rule, $data)
    {

        if ($data['type'] != '1') {
            return true;
        }
        $where[] = ['type', '=', $data['type']];
        $where[] = ['name', '=', $data['name']];

        if (!empty($data['id'])) {
            $where[] = ['id', '<>', $data['id']];
        }

        $check = (new SystemMenu())->where($where)->findOrEmpty();

        if (!$check->isEmpty()) {
            return '菜单名称已存在';
        }

        return true;
    }

}