<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\service\setting\system;

use app\adminapi\model\OperationLog;
use core\base\BaseService;

class LogService extends BaseService
{
    protected $model = null;

    public function __construct()
    {
        parent::__construct();
        $this->model = new OperationLog();
    }

    public function getPage(array $where = [])
    {
        if (isset($where['start_time']) && !empty($where['start_time'])
            && isset($where['end_time'])  && !empty($where['end_time'])) {
            $where['create_time'] = [$where['start_time'], $where['end_time']];
        }
        $field = 'id,admin_name,account,action,type,url,params,ip,location,create_time';
        $order = 'id desc';
        $search_model = $this->model
            ->withSearch(["admin_name", "type", "ip", "create_time"], $where)
            ->field($field)
            ->order($order);
        $list = $this->pageQuery($search_model);

        return $list;
    }
}