<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------

namespace app\adminapi\service\setting;

use app\adminapi\model\setting\WebsiteSettings;
use core\base\BaseService;

/**
 * 网站设置服务类
 * Class WebsiteSettingsService
 * @package app\adminapi\service\setting
 */
class WebsiteSettingsService extends BaseService
{
    /**
     * 获取网站设置详情
     */
    public function detail(): array
    {
        $setting = WebsiteSettings::find(1);
        if (!$setting) {
            // 如果没有设置记录，返回默认值
            return [
                'site_name' => '我的网站',
                'site_logo' => '',
                'login_bg_image' => '',
                'enable_captcha' => 2,
                'web_icp_record' => '',
                'web_police_record' => '',
                'web_copyright' => '',
                'web_title' => '',
                'web_logo' => '',
                'web_keywords' => '',
                'web_description' => '',
            ];
        }
        $setting->hidden(['id']);
        return $setting->toArray();
    }

    /**
     * 编辑网站设置
     */
    public function edit(array $params): bool
    {
        try {
            $setting = WebsiteSettings::find(1);
            if (!$setting) {
                // 如果没有记录，创建新记录
                $setting = new WebsiteSettings();
                $setting->id = 1;
            }

            // 更新字段
            if (isset($params['site_name'])) {
                $setting->site_name = $params['site_name'];
            }
            if (isset($params['site_logo'])) {
                $setting->site_logo = $params['site_logo'];
            }
            if (isset($params['login_bg_image'])) {
                $setting->login_bg_image = $params['login_bg_image'];
            }
            if (isset($params['enable_captcha'])) {
                $setting->enable_captcha = $params['enable_captcha'];
            }
            if (isset($params['web_icp_record'])) {
                $setting->web_icp_record = $params['web_icp_record'];
            }
            if (isset($params['web_police_record'])) {
                $setting->web_police_record = $params['web_police_record'];
            }
            if (isset($params['web_copyright'])) {
                $setting->web_copyright = $params['web_copyright'];
            }
            if (isset($params['web_title'])) {
                $setting->web_title = $params['web_title'];
            }
            if (isset($params['web_logo'])) {
                $setting->web_logo = $params['web_logo'];
            }
            if (isset($params['web_keywords'])) {
                $setting->web_keywords = $params['web_keywords'];
            }
            if (isset($params['web_description'])) {
                $setting->web_description = $params['web_description'];
            }

            return $setting->save() !== false;
        } catch (\Exception $e) {
            self::setError($e->getMessage());
            return false;
        }
    }

    public function getWebsiteConfig(): array
    {
        $data = WebsiteSettings::find(1);
        return [
            'site_name' => $data->site_name,
            'site_logo' => $data->site_logo,
            'login_bg_image' => $data->login_bg_image,
            'enable_captcha' => $data->enable_captcha,
        ];
    }
}