<?php
namespace app\adminapi\service\material\storage;

interface StorageInterface
{
    /**
     * 保存文件并返回 key/path 与 url
     * @return array{key:string,url:string}
     */
    public function put($file, string $keyPrefix = ''): array;

    /** 删除对象（key/path） */
    public function delete(string $key): void;

    /** 获取访问 URL */
    public function url(string $key): string;
}
