<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\service\auth;

use app\adminapi\model\auth\AdminRole;
use app\adminapi\model\auth\SystemMenu;
use app\adminapi\model\auth\SystemRoleMenu;
use core\base\BaseService;

class MenuService extends BaseService
{
    protected $model = null;

    public function __construct()
    {
        parent::__construct();
        $this->model = new SystemMenu();
    }

    public function add($params)
    {
        $this->model->save([
            'pid' => $params['pid'],
            'type' => $params['type'],
            'name' => $params['name'],
            'icon' => $params['icon'] ?? '',
            'icon_type' => $params['icon_type'] ?? 0,
            'sort' => $params['sort'],
            'perms' => $params['perms'] ?? '',
            'paths' => $params['paths'] ?? '',
            'component' => $params['component'] ?? '',
            'selected' => $params['selected'] ?? '',
            'params' => $params['params'] ?? '',
            'is_cache' => $params['is_cache'] ?? 0,
            'is_show' => $params['is_show'],
            'is_disable' => $params['is_disable'],
        ]);
    }

    public function edit($params)
    {
        $menu = $this->model->find($params['id']);
        $menu->save([
            'pid' => $params['pid'],
            'type' => $params['type'],
            'name' => $params['name'],
            'icon' => $params['icon'] ?? '',
            'icon_type' => $params['icon_type'] ?? 0,
            'sort' => $params['sort'],
            'perms' => $params['perms'] ?? '',
            'paths' => $params['paths'] ?? '',
            'component' => $params['component'] ?? '',
            'selected' => $params['selected'] ?? '',
            'params' => $params['params'] ?? '',
            'is_cache' => $params['is_cache'] ?? 0,
            'is_show' => $params['is_show'],
            'is_disable' => $params['is_disable'],
        ]);
    }

    public function detail($id)
    {
        $menu = $this->model->find($id);
        if (!$menu) {
            throw new \core\exception\ServerException('菜单不存在');
        }
        return $menu->toArray();
    }

    public function delete($id)
    {
        $menu = $this->model->find($id);
        if (!$menu) {
            throw new \core\exception\ServerException('菜单不存在');
        }
        (new SystemRoleMenu())->where(['menu_id' => $id])->delete();
        $menu->delete();
    }

    public function lists()
    {
        $lists = $this->model->order(['sort' => 'desc', 'id' => 'asc'])
            ->select()
            ->toArray();
        return tree($lists, 'children');
    }

    public function getAllEnableData()
    {
        $data = $this->model->where(['is_disable' => 0])
            ->field('id,pid,name,type')
            ->order(['sort' => 'desc', 'id' => 'desc'])
            ->select()
            ->toArray();

        return tree($data, 'children');
    }

    /**
     * @Desc 获取当前管理员所拥有的菜单
     * @Create on 2025/12/16 上午10:52
     * @Create by woailuo
     */
    public function getMenuByAdminId($adminArray): array
    {
        $where = [];
        if ($adminArray['is_admin'] == 0) {
            $roleIdArray = (new AdminRole())->where('admin_id', '=', $adminArray['id'])
                ->column('role_id');
            $menuIdArray = (new SystemRoleMenu())->whereIn('role_id', $roleIdArray)
                ->column('menu_id');
            $where[] = ['id', 'in', $menuIdArray];
        }

        $menu = SystemMenu::distinct(true)
            ->where([
                ['is_disable', '=', 0],
                ['type', 'in', [1,2]]

            ])
            ->where($where)
            ->order(['sort' => 'desc', 'id' => 'asc'])
            ->select();;
        return tree($menu, 'children');
    }
}