<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------

namespace app\adminapi\model\setting;

use app\common\service\FileService;
use think\Model;

/**
 * 网站设置模型
 * Class WebsiteSettings
 * @package app\adminapi\model\setting
 */
class WebsiteSettings extends Model
{
    protected $name = 'website_settings';

    /**
     * 获取网站LOGO图片完整URL
     */
    public function getSiteLogoAttr($value)
    {
        return empty($value) ? '' : FileService::getFileUrl(trim($value, '/'));
    }

    /**
     * 设置网站LOGO图片路径
     */
    public function setSiteLogoAttr($value)
    {
        return FileService::setFileUrl($value);
    }

    /**
     * 获取登录背景图片完整URL
     */
    public function getLoginBgImageAttr($value)
    {
        return empty($value) ? '' : FileService::getFileUrl(trim($value, '/'));
    }

    /**
     * 设置登录背景图片路径
     */
    public function setLoginBgImageAttr($value)
    {
        return FileService::setFileUrl($value);
    }

    /**
     * 获取网站logo图片完整URL
     */
    public function getWebLogoAttr($value)
    {
        return empty($value) ? '' : FileService::getFileUrl(trim($value, '/'));
    }

    /**
     * 设置网站logo图片路径
     */
    public function setWebLogoAttr($value)
    {
        return FileService::setFileUrl($value);
    }
}