<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\model\auth;

use app\common\service\FileService;
use think\Model;

class Admin extends Model
{
    public function adminRoleIndex()
    {
        return $this->hasMany(AdminRole::class, 'admin_id');
    }

    public function getAvatarAttr($value)
    {
        return empty($value) ? FileService::getFileUrl(config('project.default_image.admin_avatar')) : FileService::getFileUrl(trim($value, '/'));
    }

    public function setAvatarAttr($value)
    {
        return FileService::setFileUrl($value);
    }

    public function searchNameAttr($query, $value, $data)
    {
        if ($value) {
            $query->where("name", "like", "%".$value."%");
        }
    }

    public function searchAccountAttr($query, $value, $data)
    {
        if ($value) {
            $query->where("account", "like", "%".$value."%");
        }
    }

    public function getLoginTimeAttr($value)
    {
        if (empty($value)) {
            return '';
        }
        return date('Y-m-d H:i:s',$value);
    }
}