<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\middleware;

use app\Request;
use Closure;

/**
 * @Desc : 跨域中间件
 * @Create on 2025/12/17 上午10:51
 * @Create by woailuo
 */
class AllowCrossDomain
{
    public function handle(Request $request, Closure $next)
    {
        $origin = $request->header('Origin', '*');
        $allow_header = [
            'token'
        ];

        header("Access-Control-Allow-Headers: Authorization, Sec-Fetch-Mode, DNT, X-Mx-ReqToken, Keep-Alive, User-Agent, If-Match, If-None-Match, If-Unmodified-Since, X-Requested-With, If-Modified-Since, Cache-Control, Content-Type, Accept-Language, Origin, Accept-Encoding,Access-Token,version," . implode(',', $allow_header));
        header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
        header('Access-Control-Max-Age: 1728000');
        header('Access-Control-Allow-Credentials:true');
        header('Access-Control-Allow-Origin: ' . $origin);

        if ($request->isOptions()) {
            return response();
        }

        return $next($request);
    }
}