<?php
namespace app\adminapi\controller\setting\system;

use app\adminapi\service\setting\system\SystemService;
use core\base\BaseAdminController;

class SystemController extends BaseAdminController
{
    /**
     * @OA\Get(
     *     path="/setting.system.system/info",
     *     summary="系统环境",
     *     tags={"系统设置"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="获取成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(property="version", type="string", description="版本号"),
     *                 @OA\Property(
     *                     property="server",
     *                     type="object",
     *                     @OA\Property(property="os", type="string", description="操作系统"),
     *                     @OA\Property(property="server_software", type="string", description="服务器软件"),
     *                     @OA\Property(property="php_version", type="string", description="PHP版本"),
     *                     @OA\Property(property="install_path", type="string", description="安装路径"),
     *                     @OA\Property(property="disk_free", type="string", description="磁盘可用空间"),
     *                     @OA\Property(property="upload_limit", type="string", description="上传限制")
     *                 ),
     *                 @OA\Property(
     *                     property="php_items",
     *                     type="array",
     *                     @OA\Items(
     *                         @OA\Property(property="option", type="string", description="项目"),
     *                         @OA\Property(property="require", type="string", description="要求"),
     *                         @OA\Property(property="status", type="string", description="状态"),
     *                         @OA\Property(property="help", type="string", description="说明"),
     *                         @OA\Property(property="pass", type="boolean", description="是否通过")
     *                     )
     *                 ),
     *                 @OA\Property(
     *                     property="dir_items",
     *                     type="array",
     *                     @OA\Items(
     *                         @OA\Property(property="path", type="string", description="目录"),
     *                         @OA\Property(property="require", type="string", description="要求"),
     *                         @OA\Property(property="status", type="string", description="状态"),
     *                         @OA\Property(property="pass", type="boolean", description="是否通过")
     *                     )
     *                 ),
     *             )
     *         )
     *     )
     * )
     */
    public function info()
    {
        return success((new SystemService())->info());
    }
}


