<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\controller\setting\system;

use app\adminapi\service\setting\system\LogService;
use app\adminapi\validate\setting\system\LogValidate;
use core\base\BaseAdminController;

class LogController extends BaseAdminController
{

    /**
     * @Desc 系统日志
     * @OA\Get(
     *     path="/setting.system.log/lists",
     *     summary="日志列表",
     *     tags={"系统设置"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *          name="Token",
     *          in="header",
     *          description="登录Token",
     *          required=false,
     *          @OA\Schema(type="string")
     *      ),
     *     @OA\Parameter(name="admin_name", in="query", description="管理员", @OA\Schema(type="string")),
     *     @OA\Parameter(name="type", in="query", description="请求方式", @OA\Schema(type="string")),
     *     @OA\Parameter(name="ip", in="query", description="来源IP", @OA\Schema(type="string")),
     *     @OA\Parameter(name="start_time", in="query", description="开始时间", @OA\Schema(type="string", example="2025-12-10 00:00:00")),
     *     @OA\Parameter(name="end_time", in="query", description="结束时间", @OA\Schema(type="string", example="2025-12-19 00:00:00")),
     *     @OA\Parameter(name="page", in="query", description="页码", @OA\Schema(type="integer")),
     *     @OA\Parameter(name="limit", in="query", description="每页数量", @OA\Schema(type="integer")),
     *     @OA\Response(
     *         response=200,
     *         description="成功",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="操作成功"),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="list", type="array",
     *                     @OA\Items(
     *                         @OA\Property(property="id", type="integer", description="ID"),
     *                         @OA\Property(property="admin_name", type="string", description="管理员"),
     *                         @OA\Property(property="account", type="string", description="账号"),
     *                         @OA\Property(property="action", type="string", description="操作名称"),
     *                         @OA\Property(property="type", type="string", description="请求方式"),
     *                         @OA\Property(property="url", type="string", description="访问链接"),
     *                         @OA\Property(property="params", type="string", description="请求数据"),
     *                         @OA\Property(property="ip", type="string", description="IP"),
     *                         @OA\Property(property="location", type="string", description="操作地点"),
     *                         @OA\Property(property="create_time", type="integer", description="创建时间")
     *                     )
     *                 ),
     *                 @OA\Property(property="total", type="integer", description="总数")
     *             )
     *         )
     *     )
     * )
     * @Desc 日志列表
     * @Create on 2025/12/17 下午2:20
     * @Create by woailuo
     */
    public function lists() {
        $data = (new LogValidate())->get()->goCheck('lists');

        return success((new LogService())->getPage($data));
    }
}