<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------

namespace app\adminapi\controller\setting;

use app\adminapi\service\setting\WebsiteSettingsService;
use app\adminapi\validate\setting\WebsiteSettingsValidate;
use core\base\BaseAdminController;

/**
 * 网站设置控制器
 * Class WebsiteSettingsController
 * @package app\adminapi\controller\setting
 *
 * @OA\Tag(
 *     name="网站设置",
 *     description="网站基础设置相关接口"
 * )
 */
class WebsiteSettingsController extends BaseAdminController
{
    /**
     * @Desc 获取网站设置详情
     * @Create on 2026/1/15
     *
     * @OA\Get(
     *     path="/setting.websiteSettings/detail",
     *     summary="获取网站设置详情",
     *     tags={"网站设置"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="获取成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(property="id", type="integer", description="设置ID", example=1),
     *                 @OA\Property(property="site_name", type="string", description="网站名称", example="我的网站"),
     *                 @OA\Property(property="site_logo", type="string", description="网站LOGO图片URL", example="https://example.com/logo.png"),
     *                 @OA\Property(property="login_bg_image", type="string", description="登录页背景图片URL", example="https://example.com/bg.jpg"),
     *                 @OA\Property(property="enable_captcha", type="integer", description="是否开启验证码：1=开启，2=关闭", enum={1, 2}, example=2),
     *                 @OA\Property(property="web_icp_record", type="string", description="ICP备案号", example="京ICP备12345678号"),
     *                 @OA\Property(property="web_police_record", type="string", description="公安备案号", example="京公网安备11010502012345号"),
     *                 @OA\Property(property="web_copyright", type="string", description="版权信息", example="Copyright © 2026 我的网站"),
     *                 @OA\Property(property="web_title", type="string", description="网站标题", example="我的网站标题"),
     *                 @OA\Property(property="web_logo", type="string", description="网站logo URL", example="https://example.com/web_logo.png"),
     *                 @OA\Property(property="web_keywords", type="string", description="网站关键词", example="关键词1,关键词2"),
     *                 @OA\Property(property="web_description", type="string", description="网站描述", example="这是网站描述"),
     *             )
     *         )
     *     )
     * )
     */
    public function detail()
    {
        $detail = (new WebsiteSettingsService())->detail();
        return success('获取成功', $detail);
    }

    /**
     * @Desc 编辑网站设置
     * @Create on 2026/1/15
     *
     * @OA\Post(
     *     path="/setting.websiteSettings/edit",
     *     summary="编辑网站设置",
     *     tags={"网站设置"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"web_title", "web_logo"},
     *             @OA\Property(property="site_name", type="string", description="网站名称", maxLength=255, example="我的新网站"),
     *             @OA\Property(property="site_logo", type="string", description="网站LOGO图片路径", maxLength=255, example="/uploads/logo.png"),
     *             @OA\Property(property="login_bg_image", type="string", description="登录页背景图片路径", maxLength=255, example="/uploads/login_bg.jpg"),
     *             @OA\Property(property="enable_captcha", type="integer", description="是否开启验证码：1=开启，2=关闭", enum={1, 2}, example=1),
     *             @OA\Property(property="web_icp_record", type="string", description="ICP备案号", maxLength=100, example="京ICP备12345678号"),
     *             @OA\Property(property="web_police_record", type="string", description="公安备案号", maxLength=100, example="京公网安备11010502012345号"),
     *             @OA\Property(property="web_copyright", type="string", description="版权信息", maxLength=255, example="Copyright © 2026 我的网站"),
     *             @OA\Property(property="web_title", type="string", description="网站标题（必填）", maxLength=255, example="我的网站标题"),
     *             @OA\Property(property="web_logo", type="string", description="网站logo路径（必填）", maxLength=255, example="/uploads/web_logo.png"),
     *             @OA\Property(property="web_keywords", type="string", description="网站关键词", maxLength=500, example="关键词1,关键词2"),
     *             @OA\Property(property="web_description", type="string", description="网站描述", maxLength=1000, example="这是网站描述"),
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="修改成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function edit()
    {
        $params = (new WebsiteSettingsValidate())->post()->goCheck('edit');
        $result = (new WebsiteSettingsService())->edit($params);
        if (true === $result) {
            return success('修改成功');
        }
        return fail(WebsiteSettingsService::getError());
    }
}