<?php
declare (strict_types=1);

namespace app\adminapi\controller\message;

use app\common\model\sms\SmsLog;
use core\base\BaseAdminController;

/**
 * 短信记录控制器
 * Class SmsLogController
 * @package app\adminapi\controller\message
 *
 * @OA\Tag(
 *     name="短信记录",
 *     description="短信发送日志"
 * )
 */
class SmsLogController extends BaseAdminController
{
    /**
     * @Desc 短信发送记录
     * @Create on 2026/01/30
     *
     * @OA\Get(
     *     path="/message.smsLog/list",
     *     summary="短信发送记录",
     *     tags={"短信记录"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(name="mobile", in="query", description="手机号码", @OA\Schema(type="string")),
     *     @OA\Parameter(name="template_key", in="query", description="模板Key", @OA\Schema(type="string")),
     *     @OA\Parameter(name="gateway", in="query", description="网关标识", @OA\Schema(type="string")),
     *     @OA\Parameter(name="status", in="query", description="发送状态：0-失败；1-成功", @OA\Schema(type="integer")),
     *     @OA\Parameter(name="start_time", in="query", description="开始时间", @OA\Schema(type="string")),
     *     @OA\Parameter(name="end_time", in="query", description="结束时间", @OA\Schema(type="string")),
     *     @OA\Parameter(name="page_no", in="query", description="页码", @OA\Schema(type="integer")),
     *     @OA\Parameter(name="page_size", in="query", description="每页数量", @OA\Schema(type="integer")),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="获取成功"),
     *             @OA\Property(property="data", type="object",
     *                  @OA\Property(property="data", type="array", @OA\Items(
     *                      @OA\Property(property="id", type="integer", description="ID"),
     *                      @OA\Property(property="mobile", type="string", description="手机号"),
     *                      @OA\Property(property="content", type="string", description="发送内容"),
     *                      @OA\Property(property="code", type="string", description="验证码"),
     *                      @OA\Property(property="status", type="integer", description="状态"),
     *                      @OA\Property(property="gateway", type="string", description="网关"),
     *                      @OA\Property(property="template_key", type="string", description="模板Key"),
     *                      @OA\Property(property="send_time", type="integer", description="发送时间戳"),
     *                      @OA\Property(property="create_time", type="integer", description="创建时间戳"),
     *                  )),
     *                  @OA\Property(property="total", type="integer", description="总条数"),
     *                  @OA\Property(property="per_page", type="integer", description="每页数量"),
     *                  @OA\Property(property="current_page", type="integer", description="当前页码"),
     *             )
     *         )
     *     )
     * )
     */
    public function list()
    {
        $params = $this->request->get();
        $query = SmsLog::order('id', 'desc');

        if (!empty($params['mobile'])) {
            $query->whereLike('mobile', '%' . $params['mobile'] . '%');
        }
        if (!empty($params['template_key'])) {
            $query->where('template_key', $params['template_key']);
        }
        if (!empty($params['gateway'])) {
            $query->where('gateway', $params['gateway']);
        }
        if (isset($params['status']) && $params['status'] !== '') {
            $query->where('status', $params['status']);
        }
        if (!empty($params['start_time'])) {
            $query->where('send_time', '>=', strtotime($params['start_time']));
        }
        if (!empty($params['end_time'])) {
            $query->where('send_time', '<=', strtotime($params['end_time']));
        }

        $result = $query->paginate($params['per_page'] ?? 15)->toArray();
        return success('获取成功', $result);
    }
}
