<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------

namespace app\adminapi\controller\material;

use core\base\BaseAdminController;
use app\adminapi\service\material\MaterialCategoryService;
use app\adminapi\validate\material\MaterialCategoryValidate;

/**
 * @OA\Tag(
 *     name="素材分类",
 *     description="素材中心-分类相关接口"
 * )
 */
class MaterialCategoryController extends BaseAdminController
{
    /**
     * @Desc 分类树（多级）
     * @Create on 2025/12/19
     * @Create by system
     *
     * @OA\Get(
     *     path="/material.materialCategory/tree",
     *     summary="分类树（多级）",
     *     tags={"素材分类"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(
     *         name="type",
     *         in="query",
     *         description="分类类型：image|video|file（可选）",
     *         required=false,
     *         @OA\Schema(type="string", example="image")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="请求成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     @OA\Property(property="id", type="integer", description="分类ID"),
     *                     @OA\Property(property="pid", type="integer", description="父级ID"),
     *                     @OA\Property(property="name", type="string", description="分类名称"),
     *                     @OA\Property(property="type", type="string", description="类型"),
     *                     @OA\Property(property="children", type="array", description="子分类", @OA\Items(type="object"))
     *                 )
     *             )
     *         )
     *     )
     * )
     */
    public function tree()
    {
        $params = (new MaterialCategoryValidate())->get()->goCheck('tree');
        $data = (new MaterialCategoryService())->tree($params);
        return success('请求成功', $data);
    }

    /**
     * @Desc 添加分类
     * @Create on 2025/12/19
     * @Create by system
     *
     * @OA\Post(
     *     path="/material.materialCategory/add",
     *     summary="添加分类",
     *     tags={"素材分类"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"name", "type"},
     *             @OA\Property(property="pid", type="integer", description="父级ID（0为顶级）", example=0),
     *             @OA\Property(property="name", type="string", description="分类名称", example="未分组"),
     *             @OA\Property(property="type", type="string", description="分类类型：image|video|file", example="image"),
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="添加成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function add()
    {
        $params = (new MaterialCategoryValidate())->post()->goCheck('add');
        (new MaterialCategoryService())->add($params);
        return success('添加成功');
    }

    /**
     * @Desc 编辑分类
     * @Create on 2025/12/19
     * @Create by system
     *
     * @OA\Post(
     *     path="/material.materialCategory/edit",
     *     summary="编辑分类",
     *     tags={"素材分类"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"id"},
     *             @OA\Property(property="id", type="integer", description="分类ID", example=1),
     *             @OA\Property(property="pid", type="integer", description="父级ID（可选）", example=0),
     *             @OA\Property(property="name", type="string", description="分类名称（可选）", example="测试"),
     *             @OA\Property(property="type", type="string", description="分类类型（可选）", example="image"),
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="编辑成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function edit()
    {
        $params = (new MaterialCategoryValidate())->post()->goCheck('edit');
        (new MaterialCategoryService())->edit($params);
        return success('编辑成功');
    }

    /**
     * @Desc 删除分类
     * @Create on 2025/12/19
     * @Create by system
     *
     * @OA\Post(
     *     path="/material.materialCategory/delete",
     *     summary="删除分类",
     *     tags={"素材分类"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"id"},
     *             @OA\Property(property="id", type="integer", description="分类ID", example=1)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", example=1),
     *             @OA\Property(property="msg", type="string", example="删除成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function delete()
    {
        $params = (new MaterialCategoryValidate())->post()->goCheck('delete');
        $result = (new MaterialCategoryService())->delete((int)$params['id']);
        if (!$result) {
            return fail(MaterialCategoryService::getError());
        }
        return success('删除成功');
    }
}
