<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\controller\login;

use app\adminapi\service\login\CaptchaService;
use core\base\BaseAdminController;

/**
 * 验证码控制器
 * Class CaptchaController
 * @package app\adminapi\controller\login
 *
 * @OA\Tag(
 *     name="验证码模块",
 *     description="后台验证码相关接口"
 * )
 */
class CaptchaController extends BaseAdminController
{
    /**
     * @Desc 获取验证码
     *
     * @OA\Get(
     *     path="/login.captcha/get",
     *     summary="获取登录验证码",
     *     tags={"验证码模块"},
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="SUCCESS"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(property="enabled", type="integer", description="是否开启验证码 (1: 开启, 2: 关闭)", example=1),
     *                 @OA\Property(property="key", type="string", description="验证码唯一标识", example="abc123..."),
     *                 @OA\Property(property="img", type="string", description="验证码图片（Base64格式）", example="data:image/jpeg;base64,...")
     *             )
     *         )
     *     )
     * )
     */
    public function get(): \think\Response
    {
        $captchaService = new CaptchaService();
        
        // 检查是否开启验证码
        $enabled = CaptchaService::isEnabled();
        
        if (!$enabled) {
            // 未开启验证码，返回空数据
            return success([
                'enabled' => 2,
                'key' => '',
                'img' => '',
            ]);
        }
        
        // 生成验证码
        $captcha = $captchaService->generate();
        
        return success([
            'enabled' => 1,
            'key' => $captcha['key'],
            'img' => $captcha['img'],
        ]);
    }
}
