<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\controller\auth;

use app\adminapi\service\auth\MenuService;
use app\adminapi\validate\auth\MenuValidate;
use core\base\BaseAdminController;
use think\facade\Cache;

/**
 * @OA\Tag(
 *     name="菜单管理",
 *     description="菜单相关接口"
 * )
 */
class MenuController extends BaseAdminController
{

    /**
     * @Desc 添加菜单
     * @Create on 2025/12/8 下午3:17
     * @Create by woailuo
     *
     * @OA\Post(
     *     path="/auth.menu/add",
     *     summary="添加菜单",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"pid", "type", "name", "sort", "is_show", "is_disable"},
     *             @OA\Property(property="pid", type="integer", description="上级菜单ID", example=0),
     *             @OA\Property(property="type", type="integer", description="菜单类型：1=目录 2=菜单 3=按钮", enum={1, 2, 3}, example=2),
     *             @OA\Property(property="name", type="string", description="菜单名称", maxLength=30, example="测试管理"),
     *             @OA\Property(property="icon", type="string", description="菜单图标", maxLength=100, example="el-icon-test"),
     *             @OA\Property(property="icon_type", type="integer", description="菜单图标类型:0.无 1.Element图标 2.本地图标", enum={0, 1, 2}, example=1),
     *             @OA\Property(property="sort", type="integer", description="排序（值越小越靠前）", example=100),
     *             @OA\Property(property="perms", type="string", description="权限标识", maxLength=100, example="test/lists"),
     *             @OA\Property(property="paths", type="string", description="路由地址", maxLength=200, example="test"),
     *             @OA\Property(property="component", type="string", description="组件路径", maxLength=200, example="test/index"),
     *             @OA\Property(property="selected", type="string", description="选中路径", maxLength=200, example=""),
     *             @OA\Property(property="params", type="string", description="路由参数", maxLength=200, example=""),
     *             @OA\Property(property="is_cache", type="integer", description="是否缓存：0=否 1=是", enum={0, 1}, example=0),
     *             @OA\Property(property="is_show", type="integer", description="是否显示：0=隐藏 1=显示", enum={0, 1}, example=1),
     *             @OA\Property(property="is_disable", type="integer", description="是否禁用：0=启用 1=禁用", enum={0, 1}, example=0)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="添加成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function add()
    {
        $params = (new MenuValidate())->post()->goCheck('add');
        (new MenuService())->add($params);
        return success('添加成功');
    }

    /**
     * @Desc 编辑菜单
     * @Create on 2025/12/8 下午3:23
     * @Create by woailuo
     *
     * @OA\Post(
     *     path="/auth.menu/edit",
     *     summary="编辑菜单",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"id", "pid", "type", "name", "sort", "is_show", "is_disable"},
     *             @OA\Property(property="id", type="integer", description="菜单ID", example=1),
     *             @OA\Property(property="pid", type="integer", description="上级菜单ID", example=0),
     *             @OA\Property(property="type", type="integer", description="菜单类型：1=目录 2=菜单 3=按钮", enum={1, 2, 3}, example=2),
     *             @OA\Property(property="name", type="string", description="菜单名称", maxLength=30, example="测试管理"),
     *             @OA\Property(property="icon", type="string", description="菜单图标", maxLength=100, example="el-icon-test"),
     *             @OA\Property(property="icon_type", type="integer", description="菜单图标类型:0.无 1.Element图标 2.本地图标", enum={0, 1, 2}, example=1),
     *             @OA\Property(property="sort", type="integer", description="排序（值越小越靠前）", example=100),
     *             @OA\Property(property="perms", type="string", description="权限标识", maxLength=100, example="test/lists"),
     *             @OA\Property(property="paths", type="string", description="路由地址", maxLength=200, example="test"),
     *             @OA\Property(property="component", type="string", description="组件路径", maxLength=200, example="test/index"),
     *             @OA\Property(property="selected", type="string", description="选中路径", maxLength=200, example=""),
     *             @OA\Property(property="params", type="string", description="路由参数", maxLength=200, example=""),
     *             @OA\Property(property="is_cache", type="integer", description="是否缓存：0=否 1=是", enum={0, 1}, example=0),
     *             @OA\Property(property="is_show", type="integer", description="是否显示：0=隐藏 1=显示", enum={0, 1}, example=1),
     *             @OA\Property(property="is_disable", type="integer", description="是否禁用：0=启用 1=禁用", enum={0, 1}, example=0)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="编辑成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function edit()
    {
        $params = (new MenuValidate())->post()->goCheck('edit');
        (new MenuService())->edit($params);
        return success('编辑成功');
    }

    /**
     * @Desc 菜单详情
     * @Create on 2025/12/8 下午3:23
     * @Create by woailuo
     *
     * @OA\Get(
     *     path="/auth.menu/detail",
     *     summary="查看菜单详情",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(
     *         name="id",
     *         in="query",
     *         description="菜单ID",
     *         required=true,
     *         @OA\Schema(type="integer", example=1)
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="请求成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(property="id", type="integer", description="菜单ID", example=1),
     *                 @OA\Property(property="pid", type="integer", description="上级菜单ID", example=0),
     *                 @OA\Property(property="type", type="integer", description="菜单类型: 1=目录，2=菜单，3=按钮", example=2),
     *                 @OA\Property(property="name", type="string", description="菜单名称", example="测试管理"),
     *                 @OA\Property(property="icon", type="string", description="菜单图标", example="el-icon-test"),
     *                 @OA\Property(property="icon_type", type="integer", description="菜单图标类型:0.无 1.Element图标 2.本地图标", example=1),
     *                 @OA\Property(property="sort", type="integer", description="排序", example=100),
     *                 @OA\Property(property="perms", type="string", description="权限标识", example="test/lists"),
     *                 @OA\Property(property="paths", type="string", description="路由地址", example="test"),
     *                 @OA\Property(property="component", type="string", description="组件路径", example="test/index"),
     *                 @OA\Property(property="selected", type="string", description="选中路径", example=""),
     *                 @OA\Property(property="params", type="string", description="路由参数", example=""),
     *                 @OA\Property(property="is_cache", type="integer", description="是否缓存：0=否 1=是", example=0),
     *                 @OA\Property(property="is_show", type="integer", description="是否显示：0=隐藏 1=显示", example=1),
     *                 @OA\Property(property="is_disable", type="integer", description="是否禁用：0=启用 1=禁用", example=0)
     *             )
     *         )
     *     )
     * )
     */
    public function detail(){
        $params = (new MenuValidate())->get()->goCheck('detail');
        $data = (new MenuService())->detail($params['id']);
        return success('请求成功', $data);
    }

    /**
     * @Desc 删除菜单
     * @Create on 2025/12/8 下午3:27
     * @Create by woailuo
     *
     * @OA\Post(
     *     path="/auth.menu/delete",
     *     summary="删除菜单",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"id"},
     *             @OA\Property(property="id", type="integer", description="菜单ID", example=1)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="删除成功"),
     *             @OA\Property(property="data", type="object")
     *         )
     *     )
     * )
     */
    public function delete(){
        $params = (new MenuValidate())->post()->goCheck('delete');
        (new MenuService())->delete($params['id']);
        return success('删除成功');
    }

    /**
     * @Desc 菜单列表
     * @Create on 2025/12/8 下午3:38
     * @Create by woailuo
     *
     * @OA\Get(
     *     path="/auth.menu/lists",
     *     summary="菜单列表",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="请求成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 description="树形菜单列表",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", description="菜单ID", example=1),
     *                     @OA\Property(property="pid", type="integer", description="上级菜单ID", example=0),
     *                     @OA\Property(property="type", type="integer", description="菜单类型: 1=目录，2=菜单，3=按钮", example=1),
     *                     @OA\Property(property="name", type="string", description="菜单名称", example="系统管理"),
     *                     @OA\Property(property="icon", type="string", description="菜单图标", example="el-icon-setting"),
     *                     @OA\Property(property="icon_type", type="integer", description="菜单图标类型:1.Element图标 2.本地图标", example=1),
     *                     @OA\Property(property="sort", type="integer", description="排序", example=100),
     *                     @OA\Property(property="perms", type="string", description="权限标识", example=""),
     *                     @OA\Property(property="paths", type="string", description="路由地址", example="/system"),
     *                     @OA\Property(property="component", type="string", description="组件路径", example=""),
     *                     @OA\Property(property="selected", type="string", description="选中路径", example=""),
     *                     @OA\Property(property="params", type="string", description="路由参数", example=""),
     *                     @OA\Property(property="is_cache", type="integer", description="是否缓存：0=否 1=是", example=0),
     *                     @OA\Property(property="is_show", type="integer", description="是否显示：0=隐藏 1=显示", example=1),
     *                     @OA\Property(property="is_disable", type="integer", description="是否禁用：0=启用 1=禁用", example=0),
     *                     @OA\Property(
     *                         property="children",
     *                         type="array",
     *                         description="子菜单",
     *                         @OA\Items(type="object")
     *                     )
     *                 )
     *             )
     *         )
     *     )
     * )
     */
    public function lists()
    {
        if(!$this->request->isGet()) {
            fail('请求类型错误');
        }
        return success('请求成功', (new MenuService())->lists());
    }

    /**
     * @Desc 分配权限，选择菜单
     * @Create on 2025/12/9 上午9:25
     * @Create by woailuo
     *
     * @OA\Get(
     *     path="/auth.menu/assignPermissionSelectMenu",
     *     summary="分配权限选择菜单",
     *     tags={"菜单管理"},
     *     security={{"token": {}}},
     *     @OA\Parameter(
     *         name="Token",
     *         in="header",
     *         description="登录Token",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="请求成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 description="所有启用的菜单列表",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", description="菜单ID", example=1),
     *                     @OA\Property(property="pid", type="integer", description="上级菜单ID", example=0),
     *                     @OA\Property(property="name", type="string", description="菜单名称", example="系统管理"),     *
     *                     @OA\Property(property="type", type="integer", description="菜单类型：1=目录 2=菜单 3=按钮", enum={1, 2, 3}, example=2),
     *                     @OA\Property(
     *                         property="children",
     *                         type="array",
     *                         description="子菜单",
     *                         @OA\Items(type="object")
     *                     )
     *                 )
     *             )
     *         )
     *     )
     * )
     */
    public function assignPermissionSelectMenu(){
        if(!$this->request->isGet()) {
            fail('请求类型错误');
        }
        return success('请求成功', (new MenuService())->getAllEnableData());
    }
}