<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展 
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\controller;

use core\base\BaseAdminController;
use app\adminapi\service\setting\WebsiteSettingsService;

class ConfigController extends BaseAdminController
{

    /**
     * @Desc 获取后台配置（公开接口）
     * @Create on 2026/1/15
     *
     * @OA\Get(
     *     path="/config/getConfig",
     *     summary="获取后台配置",
     *     tags={"获取后台配置"},
     *     @OA\Response(
     *         response=200,
     *         description="成功响应",
     *         @OA\JsonContent(
     *             @OA\Property(property="code", type="integer", description="操作状态：0=失败 1=成功", example=1),
     *             @OA\Property(property="msg", type="string", example="获取成功"),
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(property="site_name", type="string", description="网站名称", example="我的网站"),
     *                 @OA\Property(property="site_logo", type="string", description="网站LOGO图片URL", example="https://example.com/logo.png"),
     *                 @OA\Property(property="login_bg_image", type="string", description="登录页背景图片URL", example="https://example.com/bg.jpg"),
     *                 @OA\Property(property="enable_captcha", type="integer", description="是否开启验证码：1=开启，2=关闭", enum={1, 2}, example=2)
     *             )
     *         )
     *     )
     * )
     */
    public function getConfig()
    {
        $configData = [];
        try {
            $websiteConfig = (new WebsiteSettingsService())->getWebsiteConfig();
            $configData = array_merge($websiteConfig);
            return success('获取成功', $configData);
        } catch (\Exception $e) {
            return fail('获取失败：' . $e->getMessage());
        }
    }
}