<?php
// +----------------------------------------------------------------------
// | 麦沃德科技赋能开发者，助力中小企业发展
// +----------------------------------------------------------------------
// | Copyright (c) 2017～2024  www.wdadmin.cn    All rights reserved.
// +----------------------------------------------------------------------
// | Wdadmin系统产品软件并不是自由软件，不加密，并不代表开源，未经许可不可自由转售和商用
// +----------------------------------------------------------------------
// | Author: MY WORLD Team <bd@maiwd.cn>   www.wdadmin.cn
// +----------------------------------------------------------------------
namespace app\adminapi\config;

/**
 * 白名单URL配置
 * 统一管理不需要登录验证和权限验证的路由
 */
class AllowUrlConfig
{
    /**
     * 获取 Token 免验证白名单
     * 这些路由不需要登录验证（无需 Token）
     *
     * @return array
     */
    public static function getTokenAllowList(): array
    {
        return [
            'login.login/login',      // 登录
            'login.captcha/get',      // 获取验证码
            'swagger/ui',             // Swagger UI
            'swagger/json',           // Swagger JSON
            'config/getConfig',       // 获取配置（公开接口）
        ];
    }

    /**
     * 获取权限免验证白名单
     * 这些路由不需要权限验证（但仍需登录验证）
     *
     * @return array
     */
    public static function getAuthAllowList(): array
    {
        return array_merge(self::getTokenAllowList(), [
            'login.login/logout',     // 登出（需要 Token，但不需要权限验证）
        ]);
    }

    /**
     * 检查指定 URI 是否在 Token 免验证白名单中
     *
     * @param string $uri 访问的 URI
     * @return bool
     */
    public static function isTokenAllowed(string $uri): bool
    {
        $uri = strtolower($uri);
        return in_array($uri, array_map('strtolower', self::getTokenAllowList()));
    }

    /**
     * 检查指定 URI 是否在权限免验证白名单中
     *
     * @param string $uri 访问的 URI
     * @return bool
     */
    public static function isAuthAllowed(string $uri): bool
    {
        $uri = strtolower($uri);
        return in_array($uri, array_map('strtolower', self::getAuthAllowList()));
    }
}

