import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
// 自动导入配置
import AutoImport from 'unplugin-auto-import/vite'
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'
// 组件自动注册
import Components from 'unplugin-vue-components/vite'
import { fileURLToPath, URL } from 'url'
import { defineConfig } from 'vite'
// SVG图标插件
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons'
// Vue 组件名插件
import vueSetupExtend from 'vite-plugin-vue-setup-extend'

// 路径解析函数
const resolvePath = (relativePath: string) => {
  return fileURLToPath(new URL(relativePath, import.meta.url))
}

export default defineConfig({
  base: '/admin/',
  server: {
    host: '0.0.0.0',
    open: true,
    hmr: true
  },
  plugins: [
    vue(),
    vueJsx(),
    AutoImport({
      imports: ['vue', 'vue-router', 'pinia'],
      resolvers: [ElementPlusResolver({ importStyle: false })],
      eslintrc: {
        enabled: true
      }
    }),
    Components({
      resolvers: [ElementPlusResolver({ importStyle: false })],
      directoryAsNamespace: true
    }),
    createSvgIconsPlugin({
      iconDirs: [resolvePath('./src/assets/icons')],
      symbolId: 'icon-[dir]-[name]'
    }),
    vueSetupExtend()
  ],
  resolve: {
    alias: {
      '@': resolvePath('./src')
    }
  },
  build: {
    outDir: 'dist',
    sourcemap: false,
    minify: 'esbuild',
    rollupOptions: {
      output: {
        manualChunks: {
          'vue-vendor': ['vue', 'vue-router', 'pinia'],
          'element-plus': ['element-plus'],
          axios: ['axios']
        },
        assetFileNames: 'assets/[name]-[hash][extname]',
        chunkFileNames: 'assets/[name]-[hash].js',
        entryFileNames: 'assets/[name]-[hash].js'
      }
    }
  },
  define: {
    __VUE_PROD_DEVTOOLS__: false,
    __VUE_OPTIONS_API__: true
  }
})
