import { defineStore } from 'pinia'
import defaultSetting from '@/settings'
import cache from '@/utils/cache'

interface Setting {
  theme: string
  sideTheme: string
  headerTheme: string
  fontSize: number
  sidebarWidth: number
  showSidebar: boolean
  showSwitchSidebar: boolean
  showBreadcrumb: boolean
  showBreadcrumbIcon: boolean
  showWatermark: boolean
  watermarkText: string
}

export const useSettingStore = defineStore('setting', () => {
  const cachedSetting = cache.get<Setting>('setting')
  const theme = ref(cachedSetting?.theme || defaultSetting.theme)
  const sideTheme = ref(cachedSetting?.sideTheme || defaultSetting.sideTheme)
  const headerTheme = ref(cachedSetting?.headerTheme || defaultSetting.headerTheme)
  const fontSize = ref(cachedSetting?.fontSize || defaultSetting.fontSize)
  const showSidebar = ref(cachedSetting?.showSidebar ?? defaultSetting.showSidebar)
  const sidebarWidth = ref(cachedSetting?.sidebarWidth || defaultSetting.sidebarWidth)
  const showSwitchSidebar = ref(cachedSetting?.showSwitchSidebar ?? defaultSetting.showSwitchSidebar)
  const showBreadcrumb = ref(cachedSetting?.showBreadcrumb ?? defaultSetting.showBreadcrumb)
  const showBreadcrumbIcon = ref(cachedSetting?.showBreadcrumbIcon ?? defaultSetting.showBreadcrumbIcon)
  const showWatermark = ref(cachedSetting?.showWatermark ?? false)
  const watermarkText = ref(cachedSetting?.watermarkText || '')

  const setSetting = (key: string, value: any) => {
    if (key === 'theme') {
      theme.value = value
    } else if (key === 'sideTheme') {
      sideTheme.value = value
    } else if (key === 'headerTheme') {
      headerTheme.value = value
    } else if (key === 'fontSize') {
      fontSize.value = value
    } else if (key === 'showSidebar') {
      showSidebar.value = value
    } else if (key === 'sidebarWidth') {
      sidebarWidth.value = value
    } else if (key === 'showSwitchSidebar') {
      showSwitchSidebar.value = value
    } else if (key === 'showBreadcrumb') {
      showBreadcrumb.value = value
    } else if (key === 'showBreadcrumbIcon') {
      showBreadcrumbIcon.value = value
    } else if (key === 'showWatermark') {
      showWatermark.value = value
    } else if (key === 'watermarkText') {
      watermarkText.value = value
    }
    cache.set('setting', {
      theme: theme.value,
      sideTheme: sideTheme.value,
      headerTheme: headerTheme.value,
      fontSize: fontSize.value,
      showSidebar: showSidebar.value,
      sidebarWidth: sidebarWidth.value,
      showSwitchSidebar: showSwitchSidebar.value,
      showBreadcrumb: showBreadcrumb.value,
      showBreadcrumbIcon: showBreadcrumbIcon.value,
      showWatermark: showWatermark.value,
      watermarkText: watermarkText.value
    })
  }

  const resetSetting = () => {
    theme.value = defaultSetting.theme
    sideTheme.value = defaultSetting.sideTheme
    headerTheme.value = defaultSetting.headerTheme
    fontSize.value = defaultSetting.fontSize
    showSidebar.value = defaultSetting.showSidebar
    sidebarWidth.value = defaultSetting.sidebarWidth
    showSwitchSidebar.value = defaultSetting.showSwitchSidebar
    showBreadcrumb.value = defaultSetting.showBreadcrumb
    showBreadcrumbIcon.value = defaultSetting.showBreadcrumbIcon
    showWatermark.value = false
    watermarkText.value = ''
    cache.remove('setting')
  }

  return {
    theme,
    sideTheme,
    headerTheme,
    fontSize,
    showSidebar,
    sidebarWidth,
    showSwitchSidebar,
    showBreadcrumb,
    showBreadcrumbIcon,
    showWatermark,
    watermarkText,
    setSetting,
    resetSetting
  }
})
