/**
 * 路由配置项
 *
 * path: '/path'                    // 路由路径
 * name: 'router-name'              // 路由名称，使用<keep-alive>时必须填写
 * component: Layout                // 路由组件
 * meta: {
 *   title: 'title'                 // 路由在侧边栏的显示名称
 *   icon: 'icon-name'              // 路由图标
 *   iconType: 1                    // 图标类型：1-ElementPlus图标，2-本地图标
 *   keepAlive: true                // 是否缓存路由
 *   query: { id: 1 }               // 访问路由的默认传递参数
 *   activeMenu: '/system/user'     // 高亮对应侧边栏的菜单
 * }
 */

import type { RouteRecordRaw } from 'vue-router'
import Layout from '@/layout/index.vue'
import { markRaw } from 'vue'

export const LAYOUT = () => Promise.resolve(markRaw(Layout))

export const INDEX_ROUTE_NAME = 'index'

export const constantRoutes: Array<RouteRecordRaw> = [
  {
    path: '/:pathMatch(.*)*',
    component: () => import('@/views/error/404.vue')
  },
  {
    path: '/403',
    component: () => import('@/views/error/403.vue')
  },
  {
    path: '/login',
    component: () => import('@/views/login/index.vue')
  },
  {
    path: '/user',
    component: LAYOUT,
    children: [
      {
        path: 'setting',
        component: () => import('@/views/user/setting.vue'),
        meta: {
          title: '个人设置',
          icon: 'Setting',
          iconType: 1
        }
      }
    ]
  }
]

export const INDEX_ROUTE: RouteRecordRaw = {
  path: '/',
  name: INDEX_ROUTE_NAME,
  component: LAYOUT
}
