import 'element-plus/dist/index.css'
import 'virtual:svg-icons-register'
import './styles/tailwind.css'
import './styles/index.scss'
import './permission'

import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import { useDark } from '@vueuse/core'
import { createApp } from 'vue'

import App from './App.vue'
import directive from './directive'
import router from './router'
import pinia from './stores'
import { useConfigStore } from './stores/modules/config'
import { useSettingStore } from './stores/modules/setting'
import { setThemeColor } from './utils/util'

const app = createApp(App)

// 注册Element Plus图标
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component)
}

app.use(pinia)
app.use(router)
app.use(directive)

// 初始化应用配置
const configStore = useConfigStore()
await configStore.getConfig()

// 初始化主题色
const settingStore = useSettingStore()
setThemeColor(settingStore.theme, useDark().value ? 'dark' : 'light')

app.mount('#app')
