import request from '@/utils/request'

// 登录请求
export const login = (params: Record<string, any>) => {
  return request.post({ url: '/login.login/login', params })
}

// 验证码请求
export const getCaptcha = () => {
  return request.get({ url: '/login.captcha/get' })
}

// 退出登录
export const logout = () => {
  return request.post({ url: '/login.login/logout' })
}

// 获取用户信息
export const getUserInfo = () => {
  return request.get({ url: '/auth.admin/getInfo' })
}

// 设置用户信息
export const setUserInfo = (params: Record<string, any>) => {
  return request.post({ url: '/auth.admin/profile', params })
}
