import request from '@/utils/request'

// 数据表列表
export function generatorLists(params: Record<string, any>) {
    return request.get({ url: '/tool.generator/lists', params })
}

// 生成代码
export function generatorCode(params: Record<string, any>) {
    return request.post({ url: '/tool.generator/generate', params })
}

// 获取字段详情
export function generatorColumns(params: Record<string, any>) {
    return request.get({ url: '/tool.generator/columns', params })
}

// 预览代码
export function generatorPreview(params: Record<string, any>) {
    return request.post({ url: '/tool.generator/preview', params })
}

// 删除数据表
export function generatorDelete(params: Record<string, any>) {
    return request.post({ url: '/tool.generator/delete', params })
}

// 保存数据表
export function generatorSave(params: Record<string, any>) {
    return request.post({ url: '/tool.generator/save', params })
}

// 导入表
export function generatorImport(params: any) {
    return request.post({ url: '/tool.generator/import', params })
}

// 获取模型列表
export function generatorModels() {
    return request.get({ url: '/tool.generator/models' })
}
