import request from '@/utils/request'

// 菜单列表
export const menuLists = () => {
  return request.get({ url: '/auth.menu/lists' })
}

// 菜单列表-选项
export const menuOptions = (params: Record<string, any> = {}) => {
  return request.get({ url: '/auth.menu/assignPermissionSelectMenu', params })
}

// 菜单详情
export const menuDetail = (params: Record<string, any>) => {
  return request.get({ url: '/auth.menu/detail', params })
}

// 菜单新增
export const menuAdd = (params: Record<string, any>) => {
  return request.post({ url: '/auth.menu/add', params })
}

// 菜单删除
export const menuDelete = (params: Record<string, any>) => {
  return request.post({ url: '/auth.menu/delete', params })
}

// 菜单编辑
export const menuEdit = (params: Record<string, any>) => {
  return request.post({ url: '/auth.menu/edit', params })
}
