import request from '@/utils/request'

// 短信配置列表
export const configList = () => {
  return request.get({ url: '/message.smsConfig/list' })
}

// 获取网关配置字段
export const configGateways = () => {
  return request.get({ url: '/message.smsConfig/gateways' })
}

// 获取网关配置详情
export const configDetail = (params: Record<string, any>) => {
  return request.get({ url: '/message.smsConfig/detail', params })
}

// 保存网关配置
export const configSave = (params: Record<string, any>) => {
  return request.post({ url: '/message.smsConfig/save', params })
}

// 切换启用网关
export const configSwitch = (params: Record<string, any>) => {
  return request.post({ url: '/message.smsConfig/switch', params })
}

// 测试网关
export const configTest = (params: Record<string, any>) => {
  return request.post({ url: '/message.smsConfig/test', params })
}

// 删除网关
export const configDelete = (params: Record<string, any>) => {
  return request.post({ url: '/message.smsConfig/delete', params })
}