import request from '@/utils/request'

// 素材分类列表
export function materialCateLists(params: Record<string, any>) {
  return request.get({ url: '/material.materialCategory/tree', params })
}

// 素材分类添加
export function materialCateAdd(params: Record<string, any>) {
  return request.post({ url: '/material.materialCategory/add', params })
}

// 素材分类编辑
export function materialCateEdit(params: Record<string, any>) {
  return request.post({ url: '/material.materialCategory/edit', params })
}

// 素材分类删除
export function materialCateDelete(params: Record<string, any>) {
  return request.post({ url: '/material.materialCategory/delete', params })
}

// 素材列表
export function materialLists(params: Record<string, any>) {
  return request.get({ url: '/material.material/lists', params })
}

// 素材详情
export function materialDetail(params: Record<string, any>) {
  return request.get({ url: '/material.material/detail', params })
}

// 素材删除
export function materialDelete(params: Record<string, any>) {
  return request.post({ url: '/material.material/delete', params })
}

// 素材移动
export function materialMove(params: Record<string, any>) {
  return request.post({ url: '/material.material/move', params })
}
