/* eslint-env node */
require('@rushstack/eslint-patch/modern-module-resolution')

module.exports = {
  root: true,
  ignorePatterns: ['/auto-imports.d.ts', '/components.d.ts', '/dist', '/node_modules', '*.md', '*.json'],
  extends: [
    'plugin:vue/vue3-essential',
    'eslint:recommended',
    '@vue/eslint-config-typescript/recommended',
    '@vue/eslint-config-prettier',
    'plugin:prettier/recommended',
    './.eslintrc-auto-import.json'
  ],
  plugins: ['prettier'],
  rules: {
    // Prettier 规则
    'prettier/prettier': 'error',
    // Vue 规则
    'vue/multi-word-component-names': 'off',
    'vue/prefer-import-from-vue': 'off',
    // TypeScript 规则
    '@typescript-eslint/no-explicit-any': 'off',
    '@typescript-eslint/ban-ts-comment': 'off',
    '@typescript-eslint/no-non-null-assertion': 'off',
    '@typescript-eslint/no-non-null-asserted-optional-chain': 'off',
    // 通用规则
    'no-undef': 'off',
    'no-prototype-builtins': 'off',
    'prefer-spread': 'off'
  }
}
